/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class EclipseJUnitTestsTask
extends Task {
    private String projectName;
    private String projectWorkingDir;
    private String testResourcesDir;
    private String testLibsDir;
    private String srcDir;
    private String integrationTarget;
    private String jbossHome;
    private String endorsedDir;
    private String namingProviderUrl;
    private String securityPolicy;
    private FileSet fileset;

    public void execute() throws BuildException {
        try {
            DirectoryScanner dsc = this.fileset.getDirectoryScanner(this.getProject());
            String[] classes = dsc.getIncludedFiles();
            for (int i = 0; i < classes.length; ++i) {
                String clazz = classes[i];
                File file = new File(this.getProject().getBaseDir(), EclipseJUnitTestsTask.pathToClassName(clazz) + ".launch");
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write(this.getSingleTestConf(clazz).toString());
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    public FileSet createFileset() {
        this.fileset = new FileSet();
        return this.fileset;
    }

    private static String pathToFullClassName(String path) {
        return path.substring(0, path.length() - 6).replaceAll("\\\\", ".").replaceAll("/", ".");
    }

    private static String pathToClassName(String path) {
        String fullClassName = EclipseJUnitTestsTask.pathToFullClassName(path);
        return fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
    }

    private LaunchConfiguration getSingleTestConf(String clazz) {
        LaunchConfiguration conf = new LaunchConfiguration();
        conf.addEntryToListAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_PATHS", "/" + this.projectName + "/" + this.absoluteToRelativePath(this.srcDir) + "/" + clazz.substring(0, clazz.length() - 6) + ".java");
        conf.addEntryToListAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_TYPES", "1");
        conf.putBooleanAttribute("org.eclipse.debug.core.appendEnvironmentVariables", true);
        conf.putBooleanAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        conf.putStringAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        conf.putStringAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        conf.putStringAttribute("org.eclipse.jdt.junit.TEST_KIND", "org.eclipse.jdt.junit.loader.junit3");
        conf.putStringAttribute("org.eclipse.jdt.launching.MAIN_TYPE", EclipseJUnitTestsTask.pathToFullClassName(clazz));
        conf.putStringAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", this.projectName);
        String userDir = "${workspace_loc:" + this.projectName + "}/" + this.absoluteToRelativePath(this.projectWorkingDir);
        String resourcesDir = "${workspace_loc:" + this.projectName + "}/" + this.absoluteToRelativePath(this.testResourcesDir);
        String libsDir = "${workspace_loc:" + this.projectName + "}/" + this.absoluteToRelativePath(this.testLibsDir);
        conf.putStringAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", this.getVMArguments(userDir, resourcesDir, libsDir));
        conf.putStringAttribute("org.eclipse.jdt.launching.WORKING_DIRECTORY", userDir);
        return conf;
    }

    private String getVMArguments(String userDir, String resourcesDir, String libsDir) {
        StringBuffer sb = new StringBuffer();
        sb.append("-Djbossws.integration.target=").append(this.integrationTarget);
        sb.append("&#10;-ea&#10;");
        sb.append("-Dtest.execution.dir=").append(userDir);
        sb.append("&#10;-Djava.endorsed.dirs=").append(this.endorsedDir);
        sb.append("&#10;");
        sb.append("-Djava.naming.provider.url=").append(this.namingProviderUrl);
        sb.append("&#10;-Djava.protocol.handler.pkgs=org.jboss.virtual.protocol&#10;");
        sb.append("-Djava.security.policy=").append(this.absoluteToRelativePath(this.securityPolicy));
        sb.append("&#10;-Djava.naming.factory.initial=org.jnp.interfaces.NamingContextFactory&#10;");
        sb.append("-Duser.dir=").append(userDir);
        sb.append("&#10;-Djboss.home=").append(this.jbossHome);
        sb.append("&#10;-Djdk.home=${env_var:JAVA_HOME}");
        sb.append("&#10;-Dtest.archive.directory=").append(libsDir);
        sb.append("&#10;-Dtest.resources.directory=").append(resourcesDir);
        sb.append("&#10;-Dbinary.distribution=true");
        return sb.toString();
    }

    private String absoluteToRelativePath(String absolutePath) {
        String baseDir = this.getProject().getBaseDir().toString();
        if (!absolutePath.startsWith(baseDir)) {
            throw new IllegalArgumentException("The provided absolute path is outside the current basedir: " + baseDir);
        }
        return absolutePath.substring(baseDir.length() + 1);
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectWorkingDir(String projectWorkingDir) {
        this.projectWorkingDir = projectWorkingDir;
    }

    public void setIntegrationTarget(String integrationTarget) {
        this.integrationTarget = integrationTarget;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public void setNamingProviderUrl(String namingProviderUrl) {
        this.namingProviderUrl = namingProviderUrl;
    }

    public void setSecurityPolicy(String securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void setEndorsedDir(String endorsedDir) {
        this.endorsedDir = endorsedDir;
    }

    public void setTestResourcesDir(String testResourcesDir) {
        this.testResourcesDir = testResourcesDir;
    }

    public void setTestLibsDir(String testLibsDir) {
        this.testLibsDir = testLibsDir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LaunchConfiguration {
        private Map<String, String> booleanAttributes = new LinkedHashMap<String, String>();
        private Map<String, String> stringAttributes = new LinkedHashMap<String, String>();
        private Map<String, List<String>> listAttributes = new LinkedHashMap<String, List<String>>();

        private LaunchConfiguration() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<launchConfiguration type=\"org.eclipse.jdt.junit.launchconfig\">\n");
            for (String key : this.listAttributes.keySet()) {
                sb.append("<listAttribute key=\"").append(key).append("\">\n");
                for (String value : this.listAttributes.get(key)) {
                    sb.append("<listEntry value=\"").append(value).append("\"/>\n");
                }
                sb.append("</listAttribute>\n");
            }
            for (String key : this.booleanAttributes.keySet()) {
                sb.append("<booleanAttribute key=\"").append(key);
                sb.append("\" value=\"").append(this.booleanAttributes.get(key)).append("\"/>\n");
            }
            for (String key : this.stringAttributes.keySet()) {
                sb.append("<stringAttribute key=\"").append(key);
                sb.append("\" value=\"").append(this.stringAttributes.get(key)).append("\"/>\n");
            }
            sb.append("</launchConfiguration>");
            return sb.toString();
        }

        public Map<String, String> getBooleanAttributes() {
            return this.booleanAttributes;
        }

        public void putBooleanAttribute(String name, boolean value) {
            this.booleanAttributes.put(name, String.valueOf(value));
        }

        public Map<String, String> getStringAttributes() {
            return this.stringAttributes;
        }

        public void putStringAttribute(String name, String value) {
            this.stringAttributes.put(name, value);
        }

        public Map<String, List<String>> getListAttributes() {
            return this.listAttributes;
        }

        public void addEntryToListAttribute(String attribute, String entryValue) {
            if (!this.listAttributes.containsKey(attribute)) {
                this.listAttributes.put(attribute, new LinkedList());
            }
            this.listAttributes.get(attribute).add(entryValue);
        }
    }
}

