/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.serviceref;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.jboss.wsf.common.serviceref.ServiceRefSerializer;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public abstract class AbstractServiceObjectFactoryJAXWS
implements ObjectFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            Reference ref = (Reference)obj;
            byte[] binaryData = (byte[])ref.get("SERVICE_REF_META_DATA").getContent();
            UnifiedServiceRefMetaData serviceRef = ServiceRefSerializer.unmarshall(binaryData);
            String serviceImplClass = this.getServiceClassName(serviceRef);
            String targetClassName = this.getTargetClassName(serviceRef);
            Class<?> serviceClass = this.getClass(serviceImplClass);
            Class<?> targetClass = this.getClass(targetClassName);
            this.init(serviceRef);
            try {
                Service serviceInstance = this.instantiateService(serviceRef, serviceClass);
                this.configure(serviceRef, serviceInstance);
                boolean instantiatePort = targetClassName != null && !Service.class.isAssignableFrom(targetClass);
                if (!instantiatePort) return serviceInstance;
                QName portQName = this.getPortQName(targetClassName, serviceImplClass, serviceRef);
                WebServiceFeature[] portFeatures = this.getFeatures(targetClassName, serviceImplClass, serviceRef);
                Object object = this.instantiatePort(serviceClass, targetClass, serviceInstance, portQName, portFeatures);
                return object;
            }
            finally {
                this.destroy(serviceRef);
            }
        }
        catch (Exception ex) {
            WSFException.rethrow((String)"Cannot create service", (Throwable)ex);
            return null;
        }
    }

    protected abstract void init(UnifiedServiceRefMetaData var1);

    protected abstract void configure(UnifiedServiceRefMetaData var1, Service var2);

    protected abstract void destroy(UnifiedServiceRefMetaData var1);

    private Class<?> getClass(String className) throws ClassNotFoundException {
        if (className != null) {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        return null;
    }

    private String getServiceClassName(UnifiedServiceRefMetaData serviceRefMD) {
        String serviceImplClassName = serviceRefMD.getServiceImplClass();
        if (serviceImplClassName != null) {
            return serviceImplClassName;
        }
        String serviceInterfaceName = serviceRefMD.getServiceInterface();
        if (serviceInterfaceName != null) {
            return serviceInterfaceName;
        }
        return Service.class.getName();
    }

    private String getTargetClassName(UnifiedServiceRefMetaData serviceRefMD) {
        return serviceRefMD.getServiceRefType();
    }

    private Object instantiatePort(Class<?> serviceClass, Class<?> targetClass, Service target, QName portQName, WebServiceFeature[] features) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object retVal = null;
        Object port = null;
        if (serviceClass != Service.class) {
            for (Method method : serviceClass.getDeclaredMethods()) {
                String methodName = method.getName();
                Class<?> retType = method.getReturnType();
                if (!methodName.startsWith("get") || !targetClass.isAssignableFrom(retType)) continue;
                retVal = port = method.invoke((Object)target, new Object[0]);
                break;
            }
        }
        if (port == null) {
            Method method = this.getMethodFor(portQName, features, serviceClass);
            Object[] args = this.getArgumentsFor(portQName, features, targetClass);
            retVal = port = method.invoke((Object)target, args);
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Service instantiateService(UnifiedServiceRefMetaData serviceRefMD, Class<?> serviceClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        WebServiceFeature[] features = this.getFeatures(serviceRefMD);
        URL wsdlURL = this.getWsdlURL(serviceRefMD, serviceClass);
        QName serviceQName = this.getServiceQName(serviceRefMD, serviceClass);
        Service target = null;
        if (serviceClass == Service.class) {
            if (wsdlURL == null) throw new IllegalArgumentException("Cannot create generic javax.xml.ws.Service without wsdlLocation: " + serviceRefMD);
            if (features == null) return Service.create((URL)wsdlURL, (QName)serviceQName);
            return Service.create((URL)wsdlURL, (QName)serviceQName, (WebServiceFeature[])features);
        }
        if (wsdlURL != null) {
            if (features != null) {
                Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class, WebServiceFeature[].class);
                return (Service)ctor.newInstance(wsdlURL, serviceQName, features);
            }
            Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class);
            return (Service)ctor.newInstance(wsdlURL, serviceQName);
        }
        if (features == null) return (Service)serviceClass.newInstance();
        Constructor<?> ctor = serviceClass.getConstructor(WebServiceFeature[].class);
        return (Service)ctor.newInstance(new Object[]{features});
    }

    private URL getWsdlURL(UnifiedServiceRefMetaData serviceRefMD, Class<?> serviceClass) {
        WebServiceClient webServiceClientAnnotation;
        if (serviceRefMD.getWsdlLocation() == null && (webServiceClientAnnotation = serviceClass.getAnnotation(WebServiceClient.class)) != null && webServiceClientAnnotation.wsdlLocation().length() > 0) {
            serviceRefMD.setWsdlOverride(webServiceClientAnnotation.wsdlLocation());
        }
        return serviceRefMD.getWsdlLocation();
    }

    private QName getServiceQName(UnifiedServiceRefMetaData serviceRefMD, Class<?> serviceClass) {
        WebServiceClient webServiceClientAnnotation;
        QName retVal = serviceRefMD.getServiceQName();
        if (retVal == null && (webServiceClientAnnotation = serviceClass.getAnnotation(WebServiceClient.class)) != null) {
            retVal = new QName(webServiceClientAnnotation.targetNamespace(), webServiceClientAnnotation.name());
        }
        return retVal;
    }

    private WebServiceFeature[] getFeatures(String targetClassName, String serviceClassName, UnifiedServiceRefMetaData serviceRefMD) {
        if (targetClassName != null && !targetClassName.equals(serviceClassName)) {
            Collection portComponentRefs = serviceRefMD.getPortComponentRefs();
            for (UnifiedPortComponentRefMetaData portComponentRefMD : portComponentRefs) {
                if (!targetClassName.equals(portComponentRefMD.getServiceEndpointInterface())) continue;
                return this.getFeatures(portComponentRefMD);
            }
        }
        return null;
    }

    private QName getPortQName(String targetClassName, String serviceClassName, UnifiedServiceRefMetaData serviceRefMD) {
        if (targetClassName != null && !targetClassName.equals(serviceClassName)) {
            Collection portComponentRefs = serviceRefMD.getPortComponentRefs();
            for (UnifiedPortComponentRefMetaData portComponentRefMD : portComponentRefs) {
                if (!targetClassName.equals(portComponentRefMD.getServiceEndpointInterface())) continue;
                return portComponentRefMD.getPortQName();
            }
        }
        return null;
    }

    private Method getMethodFor(QName portQName, WebServiceFeature[] features, Class<?> serviceClass) throws NoSuchMethodException {
        if (portQName == null && features == null) {
            return serviceClass.getMethod("getPort", Class.class);
        }
        if (portQName != null && features == null) {
            return serviceClass.getMethod("getPort", QName.class, Class.class);
        }
        if (portQName == null && features != null) {
            return serviceClass.getMethod("getPort", Class.class, WebServiceFeature[].class);
        }
        if (portQName != null && features != null) {
            return serviceClass.getMethod("getPort", QName.class, Class.class, WebServiceFeature[].class);
        }
        throw new IllegalStateException();
    }

    private Object[] getArgumentsFor(QName portQName, WebServiceFeature[] features, Class<?> targetClass) throws NoSuchMethodException {
        if (portQName == null && features == null) {
            return new Object[]{targetClass};
        }
        if (portQName != null && features == null) {
            return new Object[]{portQName, targetClass};
        }
        if (portQName == null && features != null) {
            return new Object[]{targetClass, features};
        }
        if (portQName != null && features != null) {
            return new Object[]{portQName, targetClass, features};
        }
        throw new IllegalStateException();
    }

    private WebServiceFeature[] getFeatures(UnifiedServiceRefMetaData serviceRef) {
        LinkedList<Object> features = new LinkedList<Object>();
        if (serviceRef.isAddressingEnabled()) {
            boolean required = serviceRef.isAddressingRequired();
            String refResponses = serviceRef.getAddressingResponses();
            AddressingFeature.Responses responses = AddressingFeature.Responses.ALL;
            if ("ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.ANONYMOUS;
            }
            if ("NON_ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.NON_ANONYMOUS;
            }
            features.add(new AddressingFeature(true, required, responses));
        }
        if (serviceRef.isMtomEnabled()) {
            features.add(new MTOMFeature(true, serviceRef.getMtomThreshold()));
        }
        if (serviceRef.isRespectBindingEnabled()) {
            features.add(new RespectBindingFeature(true));
        }
        WebServiceFeature[] wsFeatures = features.size() == 0 ? null : features.toArray(new WebServiceFeature[0]);
        return wsFeatures;
    }

    private WebServiceFeature[] getFeatures(UnifiedPortComponentRefMetaData portComponentRefMD) {
        LinkedList<Object> features = new LinkedList<Object>();
        if (portComponentRefMD.isAddressingEnabled()) {
            boolean required = portComponentRefMD.isAddressingRequired();
            String refResponses = portComponentRefMD.getAddressingResponses();
            AddressingFeature.Responses responses = AddressingFeature.Responses.ALL;
            if ("ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.ANONYMOUS;
            }
            if ("NON_ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.NON_ANONYMOUS;
            }
            features.add(new AddressingFeature(true, required, responses));
        }
        if (portComponentRefMD.isMtomEnabled()) {
            features.add(new MTOMFeature(true, portComponentRefMD.getMtomThreshold()));
        }
        if (portComponentRefMD.isRespectBindingEnabled()) {
            features.add(new RespectBindingFeature(true));
        }
        return features.size() == 0 ? null : features.toArray(new WebServiceFeature[0]);
    }
}

