/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.management.AbstractServerConfigMBean;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.management.StackConfig;
import org.jboss.wsf.spi.management.StackConfigFactory;
import org.jboss.wsf.spi.management.WebServerInfo;
import org.jboss.wsf.spi.management.WebServerInfoFactory;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;

public abstract class AbstractServerConfig
implements AbstractServerConfigMBean,
ServerConfig {
    protected static final ObjectName OBJECT_NAME_SERVER_CONFIG = ObjectNameFactory.create("jboss.system:type=ServerConfig");
    private volatile MBeanServer mbeanServer;
    private volatile String webServiceHost = "jbossws.undefined.host";
    private int webServicePort;
    private final Object webServicePortLock = new Object();
    private int webServiceSecurePort;
    private final Object webServiceSecurePortLock = new Object();
    private volatile boolean modifySOAPAddress;
    protected StackConfig stackConfig;
    private final List<ClientConfig> clientConfigs = new CopyOnWriteArrayList<ClientConfig>();
    private final List<EndpointConfig> endpointConfigs = new CopyOnWriteArrayList<EndpointConfig>();
    private static ServerConfig serverConfig;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    public void setWebServiceHost(String host) throws UnknownHostException {
        if (host == null || host.trim().length() == 0) {
            Loggers.MANAGEMENT_LOGGER.usingUndefinedWebServicesHost("jbossws.undefined.host");
            host = "jbossws.undefined.host";
        }
        if ("0.0.0.0".equals(host)) {
            InetAddress localHost = InetAddress.getLocalHost();
            if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                Loggers.MANAGEMENT_LOGGER.usingLocalHostWebServicesHost(localHost.getHostName());
            }
            host = localHost.getHostName();
        }
        this.webServiceHost = this.toIPv6URLFormat("127.0.0.1".equals(host) ? "localhost" : host);
    }

    private String toIPv6URLFormat(String host) {
        boolean isIPv6Address = false;
        String resolvedAddress = null;
        try {
            InetAddress address = InetAddress.getByName(host);
            isIPv6Address = !"jbossws.undefined.host".equals(host) && address instanceof Inet6Address;
            resolvedAddress = isIPv6Address ? address.getHostAddress() : null;
        }
        catch (UnknownHostException e) {
            Loggers.MANAGEMENT_LOGGER.couldNotGetAddressForHost(host, e);
        }
        boolean isIPv6AddressHost = isIPv6Address && host.equals(resolvedAddress);
        return isIPv6AddressHost ? "[" + host + "]" : host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebServicePort(int port) {
        Object object = this.webServicePortLock;
        synchronized (object) {
            this.webServicePort = port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebServiceSecurePort(int port) {
        Object object = this.webServiceSecurePortLock;
        synchronized (object) {
            this.webServiceSecurePort = port;
        }
    }

    public boolean isModifySOAPAddress() {
        return this.modifySOAPAddress;
    }

    public void setModifySOAPAddress(boolean modify) {
        this.modifySOAPAddress = modify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWebServicePort() {
        Object object = this.webServicePortLock;
        synchronized (object) {
            int localPort;
            if (this.webServicePort <= 0) {
                this.webServicePort = this.getConnectorPort(false);
            }
            if ((localPort = this.webServicePort) <= 0) {
                if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                    Loggers.MANAGEMENT_LOGGER.unableToCalculateWebServicesPort("8080");
                }
                localPort = 8080;
            }
            return localPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWebServiceSecurePort() {
        Object object = this.webServiceSecurePortLock;
        synchronized (object) {
            int localPort;
            if (this.webServiceSecurePort <= 0) {
                this.webServiceSecurePort = this.getConnectorPort(true);
            }
            if ((localPort = this.webServiceSecurePort) <= 0) {
                if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                    Loggers.MANAGEMENT_LOGGER.unableToCalculateWebServicesSecurePort("8443");
                }
                localPort = 8443;
            }
            return localPort;
        }
    }

    private int getConnectorPort(boolean secure) {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        int port = 0;
        try {
            WebServerInfo webServerInfo = ((WebServerInfoFactory)SPIProvider.getInstance().getSPI(WebServerInfoFactory.class, cl)).newWebServerInfo();
            port = webServerInfo.getPort("HTTP/1.1", secure);
        }
        catch (WSFException e) {
            Loggers.MANAGEMENT_LOGGER.couldNotGetPortFromConfiguredHTTPConnector();
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws Exception {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        this.stackConfig = ((StackConfigFactory)SPIProvider.getInstance().getSPI(StackConfigFactory.class, cl)).getStackConfig();
        Loggers.MANAGEMENT_LOGGER.startingWSServerConfig(this.getImplementationTitle(), this.getImplementationVersion());
        MBeanServer mbeanServer = this.getMbeanServer();
        if (mbeanServer != null) {
            mbeanServer.registerMBean(this, AbstractServerConfigMBean.OBJECT_NAME);
        }
        Class<AbstractServerConfig> clazz = AbstractServerConfig.class;
        synchronized (AbstractServerConfig.class) {
            serverConfig = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void destroy() throws Exception {
        MBeanServer mbeanServer = this.getMbeanServer();
        if (mbeanServer != null) {
            mbeanServer.unregisterMBean(AbstractServerConfigMBean.OBJECT_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerConfig getServerIntegrationServerConfig() {
        Class<AbstractServerConfig> clazz = AbstractServerConfig.class;
        synchronized (AbstractServerConfig.class) {
            if (serverConfig == null) {
                ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
                serverConfig = ((ServerConfigFactory)SPIProvider.getInstance().getSPI(ServerConfigFactory.class, cl)).getServerConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverConfig;
        }
    }

    public String getImplementationTitle() {
        return this.stackConfig.getImplementationTitle();
    }

    public String getImplementationVersion() {
        return this.stackConfig.getImplementationVersion();
    }

    public void addEndpointConfig(EndpointConfig config) {
        this.endpointConfigs.add(config);
    }

    public void addClientConfig(ClientConfig config) {
        this.clientConfigs.add(config);
    }

    public List<EndpointConfig> getEndpointConfigs() {
        return this.endpointConfigs;
    }

    public List<ClientConfig> getClientConfigs() {
        return this.clientConfigs;
    }
}

