/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.management.DefaultEndpointRegistry;
import org.jboss.ws.common.management.ManagedEndpoint;
import org.jboss.ws.common.management.ManagedEndpointRegistryMBean;
import org.jboss.wsf.spi.deployment.Endpoint;

public class ManagedEndpointRegistry
extends DefaultEndpointRegistry
implements ManagedEndpointRegistryMBean {
    private MBeanServer mbeanServer;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Override
    public void register(Endpoint endpoint) {
        super.register(endpoint);
        try {
            ManagedEndpoint jmxEndpoint = new ManagedEndpoint(endpoint, this.mbeanServer);
            this.getMbeanServer().registerMBean(jmxEndpoint, endpoint.getName());
        }
        catch (Exception ex) {
            Loggers.MANAGEMENT_LOGGER.cannotRegisterEndpointWithJmxServer(endpoint.getName(), ex);
        }
    }

    @Override
    public void unregister(Endpoint endpoint) {
        super.unregister(endpoint);
        try {
            if (this.getMbeanServer() != null) {
                this.getMbeanServer().unregisterMBean(endpoint.getName());
            } else {
                Loggers.MANAGEMENT_LOGGER.cannotUnregisterDueToMBeanServerUnavailable();
            }
        }
        catch (JMException ex) {
            Loggers.MANAGEMENT_LOGGER.cannotUnregisterEndpointWithJmxServer(endpoint.getName(), ex);
        }
    }

    public void create() throws Exception {
        if (this.mbeanServer != null) {
            this.getMbeanServer().registerMBean(this, OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        Loggers.MANAGEMENT_LOGGER.destroyingServiceEndpointManager();
        if (this.mbeanServer != null) {
            this.getMbeanServer().unregisterMBean(OBJECT_NAME);
        }
    }
}

