/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.management.NotCompliantMBeanException;
import javax.net.SocketFactory;
import org.jboss.xnio.ManagedSocket;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.Xnio;

final class ManagedSocketFactory
extends SocketFactory {
    private final OptionMap optionMap;
    private final Xnio xnio;

    ManagedSocketFactory(Xnio xnio, OptionMap optionMap) {
        this.optionMap = optionMap;
        this.xnio = xnio;
    }

    @Override
    public Socket createSocket() throws IOException {
        OptionMap optionMap = this.optionMap;
        ManagedSocket socket = new ManagedSocket();
        socket.configure(optionMap);
        if (optionMap.get(Options.MANAGE_CONNECTIONS, true)) {
            try {
                socket.setRegistration(this.xnio.registerMBean(socket.getMBean()));
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new IOException("Cannot register channel MBean");
            }
        }
        return socket;
    }

    @Override
    public Socket createSocket(String remoteHost, int remotePort) throws IOException {
        return this.createSocket(InetAddress.getByName(remoteHost), remotePort);
    }

    @Override
    public Socket createSocket(String remoteHost, int remotePort, InetAddress bindAddress, int bindPort) throws IOException {
        return this.createSocket(InetAddress.getByName(remoteHost), remotePort, bindAddress, bindPort);
    }

    @Override
    public Socket createSocket(InetAddress remoteAddress, int remotePort) throws IOException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(remoteAddress, remotePort));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress remoteAddress, int remotePort, InetAddress bindAddress, int bindPort) throws IOException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(bindAddress, bindPort));
        socket.connect(new InetSocketAddress(remoteAddress, remotePort));
        return socket;
    }
}

