/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.channels.Channels;
import org.jboss.xnio.channels.StreamSourceChannel;

public class BufferedChannelInputStream
extends InputStream {
    private final StreamSourceChannel channel;
    private final ByteBuffer buffer;
    private volatile boolean closed;

    public BufferedChannelInputStream(StreamSourceChannel channel, int bufferSize) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be at least one byte");
        }
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        ByteBuffer buffer = this.buffer;
        StreamSourceChannel channel = this.channel;
        while (!buffer.hasRemaining()) {
            buffer.clear();
            int res = Channels.readBlocking(channel, buffer);
            if (res == -1) {
                return -1;
            }
            buffer.flip();
        }
        return buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        int total = 0;
        ByteBuffer buffer = this.buffer;
        if (buffer.hasRemaining()) {
            int cnt = Math.min(buffer.remaining(), len);
            buffer.get(b, off, len);
            total += cnt;
            off += cnt;
            len -= cnt;
        }
        if (this.closed) {
            return -1;
        }
        StreamSourceChannel channel = this.channel;
        while (len > 0) {
            int res;
            ByteBuffer dst = ByteBuffer.wrap(b, off, len);
            int n = res = total > 0 ? channel.read(dst) : Channels.readBlocking(channel, dst);
            if (res == -1) {
                return total == 0 ? -1 : total;
            }
            total += res;
            if (res == 0) break;
        }
        return total;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        long total = 0L;
        ByteBuffer buffer = this.buffer;
        if (buffer.hasRemaining()) {
            int cnt = (int)Math.min((long)buffer.remaining(), n);
            Buffers.skip(buffer, cnt);
            total += (long)cnt;
            n -= (long)cnt;
        }
        if (this.closed) {
            return total;
        }
        StreamSourceChannel channel = this.channel;
        if (n > 0L) {
            try {
                while (n > 0L) {
                    int res;
                    buffer.clear();
                    int n2 = res = total > 0L ? channel.read(buffer) : Channels.readBlocking(channel, buffer);
                    if (res <= 0) {
                        long l = total;
                        return l;
                    }
                    total += (long)res;
                }
            }
            finally {
                buffer.position(0).limit(0);
            }
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        ByteBuffer buffer = this.buffer;
        int rem = buffer.remaining();
        if (rem > 0 || this.closed) {
            return rem;
        }
        buffer.clear();
        try {
            this.channel.read(buffer);
        }
        catch (IOException e) {
            buffer.limit(0);
            throw e;
        }
        buffer.flip();
        return buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.channel.shutdownReads();
    }
}

