/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.channels.Channel;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.SuspendableChannel;
import org.xnio.channels.WrappedChannel;

public abstract class TranslatingSuspendableChannel<C extends SuspendableChannel, W extends SuspendableChannel>
implements SuspendableChannel,
WrappedChannel<W> {
    protected final W channel;
    private final ChannelListener.SimpleSetter<C> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> closeSetter = new ChannelListener.SimpleSetter();
    private volatile int state;
    private volatile Thread[] readWaiters = NOT_WAITING;
    private volatile Thread[] writeWaiters = NOT_WAITING;
    private static final Thread[] NOT_WAITING = new Thread[0];
    private static final AtomicIntegerFieldUpdater<TranslatingSuspendableChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(TranslatingSuspendableChannel.class, "state");
    private static final AtomicReferenceFieldUpdater<TranslatingSuspendableChannel, Thread[]> readWaitersUpdater = AtomicReferenceFieldUpdater.newUpdater(TranslatingSuspendableChannel.class, Thread[].class, "readWaiters");
    private static final AtomicReferenceFieldUpdater<TranslatingSuspendableChannel, Thread[]> writeWaitersUpdater = AtomicReferenceFieldUpdater.newUpdater(TranslatingSuspendableChannel.class, Thread[].class, "writeWaiters");
    private static final int READ_REQUESTED = 1;
    private static final int READ_REQUIRES_WRITE = 2;
    private static final int READ_READY = 4;
    private static final int READ_SHUT_DOWN = 8;
    private static final int READ_REQUIRES_EXT = 63488;
    private static final int READ_SINGLE_EXT = 2048;
    private static final int READ_FLAGS = 65535;
    private static final int WRITE_REQUESTED = 65536;
    private static final int WRITE_REQUIRES_READ = 131072;
    private static final int WRITE_READY = 262144;
    private static final int WRITE_SHUT_DOWN = 524288;
    private static final int WRITE_COMPLETE = 0x100000;
    private static final int WRITE_REQUIRES_EXT = -134217728;
    private static final int WRITE_SINGLE_EXT = 0x8000000;
    private static final int WRITE_FLAGS = -65536;
    private final ChannelListener<Channel> readListener = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            TranslatingSuspendableChannel.this.handleReadable();
        }

        public String toString() {
            return "Read listener for " + TranslatingSuspendableChannel.this;
        }
    };
    private final ChannelListener<Channel> writeListener = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            TranslatingSuspendableChannel.this.handleWritable();
        }

        public String toString() {
            return "Write listener for " + TranslatingSuspendableChannel.this;
        }
    };
    private final ChannelListener<Channel> closeListener = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            IoUtils.safeClose(TranslatingSuspendableChannel.this);
        }

        public String toString() {
            return "Close listener for " + TranslatingSuspendableChannel.this;
        }
    };

    protected TranslatingSuspendableChannel(W channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.channel = channel;
        channel.getReadSetter().set(this.readListener);
        channel.getWriteSetter().set(this.writeListener);
        channel.getCloseSetter().set(this.closeListener);
    }

    protected void handleReadable() {
        ChannelListener<C> listener = this.readSetter.get();
        if (listener == null) {
            this.suspendReads();
            return;
        }
        int oldState = this.clearFlags(131072);
        if (TranslatingSuspendableChannel.allAreSet(oldState, 131072)) {
            this.unparkWriteWaiters();
            if (TranslatingSuspendableChannel.allAreSet(oldState, 65536)) {
                this.channel.wakeupWrites();
            }
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, 4) && TranslatingSuspendableChannel.anyAreSet(oldState, 63490)) {
            this.channel.suspendReads();
            return;
        }
        do {
            if (TranslatingSuspendableChannel.anyAreSet(oldState, 8) || TranslatingSuspendableChannel.allAreClear(oldState, 1)) {
                this.channel.suspendReads();
                return;
            }
            this.unparkReadWaiters();
            ChannelListeners.invokeChannelListener(this.thisTyped(), listener);
            oldState = this.clearFlags(131072);
            if (!TranslatingSuspendableChannel.allAreSet(oldState, 131072)) continue;
            this.unparkWriteWaiters();
            this.channel.wakeupWrites();
        } while (TranslatingSuspendableChannel.allAreSet(oldState, 4));
    }

    protected void handleWritable() {
        ChannelListener<C> listener = this.writeSetter.get();
        if (listener == null) {
            this.suspendWrites();
            return;
        }
        int oldState = this.clearFlags(2);
        if (TranslatingSuspendableChannel.allAreSet(oldState, 2)) {
            this.unparkReadWaiters();
            if (TranslatingSuspendableChannel.allAreSet(oldState, 1)) {
                this.channel.wakeupReads();
            }
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, 262144) && TranslatingSuspendableChannel.anyAreSet(oldState, -134086656)) {
            this.channel.suspendWrites();
            return;
        }
        do {
            if (TranslatingSuspendableChannel.anyAreSet(oldState, 0x100000) || TranslatingSuspendableChannel.allAreClear(oldState, 65536)) {
                this.channel.suspendWrites();
                return;
            }
            this.unparkWriteWaiters();
            ChannelListeners.invokeChannelListener(this.thisTyped(), listener);
            oldState = this.clearFlags(2);
            if (!TranslatingSuspendableChannel.allAreSet(oldState, 2)) continue;
            this.unparkReadWaiters();
            this.channel.wakeupReads();
        } while (TranslatingSuspendableChannel.allAreSet(oldState, 262144));
    }

    protected void handleClosed() {
        ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeSetter.get());
    }

    protected void setReadReady() {
        int oldState = this.setFlags(4);
        if (TranslatingSuspendableChannel.allAreSet(oldState, 4)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreSet(oldState, 1) && TranslatingSuspendableChannel.anyAreSet(oldState, 63490)) {
            this.channel.wakeupReads();
        }
    }

    protected void clearReadReady() {
        int oldState = this.clearFlags(4);
        if (TranslatingSuspendableChannel.allAreClear(oldState, 4)) {
            return;
        }
        if (!TranslatingSuspendableChannel.allAreClear(oldState, 1) && !TranslatingSuspendableChannel.anyAreSet(oldState, 63490)) {
            this.channel.resumeReads();
        }
    }

    protected void setReadRequiresWrite() {
        int oldState = this.setFlags(2);
        if (TranslatingSuspendableChannel.allAreSet(oldState, 2)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, 63492)) {
            this.channel.resumeWrites();
        }
    }

    protected boolean readRequiresWrite() {
        return TranslatingSuspendableChannel.allAreSet(this.state, 2);
    }

    protected void clearReadRequiresWrite() {
        int oldState = this.clearFlags(2);
        if (TranslatingSuspendableChannel.allAreClear(oldState, 2)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, 63488) && TranslatingSuspendableChannel.allAreSet(oldState, 1)) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 4)) {
                this.channel.wakeupReads();
            } else {
                this.channel.resumeReads();
            }
        }
    }

    protected boolean tryAddReadRequiresExternal() {
        int oldState = this.addFlag(63488, 2048);
        return (oldState & 0xF800) != 63488;
    }

    protected void removeReadRequiresExternal() {
        this.clearFlag(2048);
    }

    protected boolean setReadShutDown() {
        return (this.setFlags(8) & 0x80008) == 524288;
    }

    protected void setWriteReady() {
        int oldState = this.setFlags(262144);
        if (TranslatingSuspendableChannel.allAreSet(oldState, 262144)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreSet(oldState, 65536) && TranslatingSuspendableChannel.anyAreSet(oldState, -134086656)) {
            this.channel.wakeupWrites();
        }
    }

    protected void clearWriteReady() {
        int oldState = this.clearFlags(262144);
        if (TranslatingSuspendableChannel.allAreClear(oldState, 262144)) {
            return;
        }
        if (!TranslatingSuspendableChannel.allAreClear(oldState, 65536) && !TranslatingSuspendableChannel.anyAreSet(oldState, -134086656)) {
            this.channel.resumeWrites();
        }
    }

    protected void setWriteRequiresRead() {
        int oldState = this.setFlags(131072);
        if (TranslatingSuspendableChannel.allAreSet(oldState, 131072)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, -133955584)) {
            this.channel.resumeReads();
        }
    }

    protected boolean writeRequiresRead() {
        return TranslatingSuspendableChannel.allAreSet(this.state, 131072);
    }

    protected void clearWriteRequiresRead() {
        int oldState = this.clearFlags(131072);
        if (TranslatingSuspendableChannel.allAreClear(oldState, 131072)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, -134217728) && TranslatingSuspendableChannel.allAreSet(oldState, 65536)) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 262144)) {
                this.channel.wakeupWrites();
            } else {
                this.channel.resumeWrites();
            }
        }
    }

    protected boolean tryAddWriteRequiresExternal() {
        int oldState = this.addFlag(-134217728, 0x8000000);
        return (oldState & 0xF8000000) != -134217728;
    }

    protected void removeWriteRequiresExternal() {
        this.clearFlag(0x8000000);
    }

    protected boolean setWriteShutDown() {
        return (this.setFlags(524288) & 0x80008) == 8;
    }

    protected boolean setClosed() {
        return (this.setFlags(524296) & 0x80008) != 524296;
    }

    protected final C thisTyped() {
        return (C)this;
    }

    public ChannelListener.Setter<C> getCloseSetter() {
        return this.closeSetter;
    }

    public ChannelListener.Setter<C> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<C> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public void suspendReads() {
        this.clearFlags(1);
    }

    @Override
    public void resumeReads() {
        int oldState = this.setFlags(1);
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 9)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreSet(oldState, 4)) {
            this.channel.wakeupReads();
            return;
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, 63488)) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 2)) {
                this.channel.resumeWrites();
            } else {
                this.channel.resumeReads();
            }
        }
    }

    @Override
    public boolean isReadResumed() {
        return TranslatingSuspendableChannel.allAreSet(this.state, 1);
    }

    @Override
    public void wakeupReads() {
        int oldState = this.setFlags(1);
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 8)) {
            return;
        }
        this.channel.wakeupReads();
    }

    @Override
    public void suspendWrites() {
        this.clearFlags(65536);
    }

    @Override
    public void resumeWrites() {
        int oldState = this.setFlags(65536);
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 0x110000)) {
            return;
        }
        if (TranslatingSuspendableChannel.allAreSet(oldState, 262144)) {
            this.channel.wakeupWrites();
            return;
        }
        if (TranslatingSuspendableChannel.allAreClear(oldState, -134217728)) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 131072)) {
                this.channel.resumeReads();
            } else {
                this.channel.resumeWrites();
            }
        }
    }

    @Override
    public boolean isWriteResumed() {
        return TranslatingSuspendableChannel.allAreSet(this.state, 65536);
    }

    @Override
    public void wakeupWrites() {
        int oldState = this.setFlags(65536);
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 0x100000)) {
            return;
        }
        this.channel.wakeupWrites();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.channel.setOption(option, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean flush() throws IOException {
        int oldState = stateUpdater.get(this);
        if (TranslatingSuspendableChannel.allAreSet(oldState, 0x100000)) {
            return this.channel.flush();
        }
        boolean shutDown = TranslatingSuspendableChannel.allAreSet(oldState, 524288);
        if (!this.flushAction(shutDown)) {
            return false;
        }
        if (!shutDown) {
            return true;
        }
        int newState = oldState | 0x100000;
        while (!stateUpdater.compareAndSet(this, oldState, newState)) {
            oldState = stateUpdater.get(this);
            if (TranslatingSuspendableChannel.allAreSet(oldState, 0x100000)) {
                return this.channel.flush();
            }
            newState = oldState | 0x100000;
        }
        boolean readShutDown = TranslatingSuspendableChannel.allAreSet(oldState, 8);
        try {
            this.shutdownWritesComplete(readShutDown);
        }
        finally {
            if (readShutDown) {
                ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeSetter.get());
            }
        }
        return this.channel.flush();
    }

    protected boolean flushAction(boolean shutDown) throws IOException {
        return this.channel.flush();
    }

    protected void shutdownWritesComplete(boolean readShutDown) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownReads() throws IOException {
        int old = this.setFlags(8);
        if (TranslatingSuspendableChannel.allAreClear(old, 8)) {
            boolean writeComplete = TranslatingSuspendableChannel.allAreSet(old, 0x100000);
            try {
                this.shutdownReadsAction(writeComplete);
            }
            finally {
                if (writeComplete) {
                    ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeSetter.get());
                }
            }
        }
    }

    protected void shutdownReadsAction(boolean writeComplete) throws IOException {
        this.channel.shutdownReads();
    }

    protected boolean isReadShutDown() {
        return TranslatingSuspendableChannel.allAreSet(this.state, 8);
    }

    @Override
    public void shutdownWrites() throws IOException {
        int old = this.setFlags(524288);
        if (TranslatingSuspendableChannel.allAreClear(old, 524288)) {
            this.shutdownWritesAction();
        }
    }

    protected void shutdownWritesAction() throws IOException {
        this.channel.shutdownWrites();
    }

    protected boolean isWriteShutDown() {
        return TranslatingSuspendableChannel.allAreSet(this.state, 524288);
    }

    protected boolean isWriteComplete() {
        return TranslatingSuspendableChannel.allAreSet(this.state, 0x100000);
    }

    @Override
    public void awaitReadable() throws IOException {
        int oldState = this.state;
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 12)) {
            return;
        }
        if (this.addReadWaiter()) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 2)) {
                this.channel.resumeWrites();
            } else {
                this.channel.resumeReads();
            }
            LockSupport.park(this);
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        int oldState = this.state;
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 12)) {
            return;
        }
        if (this.addReadWaiter()) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 2)) {
                this.channel.resumeWrites();
            } else {
                this.channel.resumeReads();
            }
            LockSupport.parkNanos(this, timeUnit.toNanos(time));
        }
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.channel.getReadThread();
    }

    @Override
    public void awaitWritable() throws IOException {
        int oldState = this.state;
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 786432)) {
            return;
        }
        if (this.addWriteWaiter()) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 131072)) {
                this.channel.resumeReads();
            } else {
                this.channel.resumeWrites();
            }
            LockSupport.park(this);
        }
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        int oldState = this.state;
        if (TranslatingSuspendableChannel.anyAreSet(oldState, 786432)) {
            return;
        }
        if (this.addWriteWaiter()) {
            if (TranslatingSuspendableChannel.allAreSet(oldState, 131072)) {
                this.channel.resumeReads();
            } else {
                this.channel.resumeWrites();
            }
            LockSupport.parkNanos(this, timeUnit.toNanos(time));
        }
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.channel.getWriteThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int old = this.setFlags(0x180008);
        boolean readShutDown = TranslatingSuspendableChannel.allAreSet(old, 8);
        boolean writeShutDown = TranslatingSuspendableChannel.allAreSet(old, 0x100000);
        if (!readShutDown || !writeShutDown) {
            try {
                this.closeAction(readShutDown, writeShutDown);
            }
            finally {
                ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeSetter.get());
            }
        }
    }

    protected void closeAction(boolean readShutDown, boolean writeShutDown) throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return !TranslatingSuspendableChannel.allAreSet(this.state, 0x100008);
    }

    @Override
    public W getChannel() {
        return this.channel;
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public String toString() {
        return this.getClass().getName() + " around " + this.channel;
    }

    private int setFlags(int flags) {
        int oldState;
        do {
            if (((oldState = this.state) & flags) != flags) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState | flags));
        return oldState;
    }

    private int clearFlags(int flags) {
        int oldState;
        do {
            if (((oldState = this.state) & flags) != 0) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState & ~flags));
        return oldState;
    }

    private int addFlag(int mask, int count) {
        int oldState;
        do {
            if (((oldState = this.state) & mask) != mask) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState + count));
        return oldState;
    }

    private int clearFlag(int count) {
        return stateUpdater.getAndAdd(this, -count);
    }

    private static boolean anyAreSet(int var, int flags) {
        return (var & flags) != 0;
    }

    private static boolean allAreSet(int var, int flags) {
        return (var & flags) == flags;
    }

    private static boolean allAreClear(int var, int flags) {
        return (var & flags) == 0;
    }

    private boolean addReadWaiter() {
        Thread[] newWaiters;
        Thread[] oldWaiters;
        do {
            if ((oldWaiters = this.readWaiters) == NOT_WAITING) {
                return false;
            }
            if (oldWaiters == null) {
                newWaiters = new Thread[]{Thread.currentThread()};
                continue;
            }
            int oldLength = oldWaiters.length;
            for (int i = 0; i < oldLength; ++i) {
                if (oldWaiters[i] != Thread.currentThread()) continue;
                return true;
            }
            newWaiters = Arrays.copyOf(oldWaiters, oldLength + 1);
            newWaiters[oldLength] = Thread.currentThread();
        } while (!readWaitersUpdater.compareAndSet(this, oldWaiters, newWaiters));
        return true;
    }

    private boolean addWriteWaiter() {
        Thread[] newWaiters;
        Thread[] oldWaiters;
        do {
            if ((oldWaiters = this.writeWaiters) == NOT_WAITING) {
                return false;
            }
            if (oldWaiters == null) {
                newWaiters = new Thread[]{Thread.currentThread()};
                continue;
            }
            int oldLength = oldWaiters.length;
            for (int i = 0; i < oldLength; ++i) {
                if (oldWaiters[i] != Thread.currentThread()) continue;
                return true;
            }
            newWaiters = Arrays.copyOf(oldWaiters, oldLength + 1);
            newWaiters[oldLength] = Thread.currentThread();
        } while (!writeWaitersUpdater.compareAndSet(this, oldWaiters, newWaiters));
        return true;
    }

    private void unparkReadWaiters() {
        Thread[] waiters;
        for (Thread waiter : waiters = readWaitersUpdater.getAndSet(this, NOT_WAITING)) {
            LockSupport.unpark(waiter);
        }
    }

    private void unparkWriteWaiters() {
        Thread[] waiters;
        for (Thread waiter : waiters = writeWaitersUpdater.getAndSet(this, NOT_WAITING)) {
            LockSupport.unpark(waiter);
        }
    }
}

