/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.ProtectedWrappedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class FixedLengthStreamSourceChannel
implements StreamSourceChannel,
ProtectedWrappedChannel<StreamSourceChannel> {
    private final StreamSourceChannel delegate;
    private final boolean configurable;
    private final Object guard;
    private final ChannelListener<? super FixedLengthStreamSourceChannel> finishListener;
    private final ChannelListener.SimpleSetter<FixedLengthStreamSourceChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<FixedLengthStreamSourceChannel> closeSetter = new ChannelListener.SimpleSetter();
    private volatile long state;
    private static final long FLAG_READ_ENTERED = Long.MIN_VALUE;
    private static final long FLAG_CLOSED = 0x4000000000000000L;
    private static final long FLAG_SUS_RES_SHUT = 0x2000000000000000L;
    private static final long FLAG_FINISHED = 0x1000000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 59);
    private static final AtomicLongFieldUpdater<FixedLengthStreamSourceChannel> stateUpdater = AtomicLongFieldUpdater.newUpdater(FixedLengthStreamSourceChannel.class, "state");

    public FixedLengthStreamSourceChannel(StreamSourceChannel delegate, long contentLength, ChannelListener<? super FixedLengthStreamSourceChannel> finishListener, Object guard) {
        this(delegate, contentLength, false, finishListener, guard);
    }

    public FixedLengthStreamSourceChannel(StreamSourceChannel delegate, long contentLength, boolean configurable, ChannelListener<? super FixedLengthStreamSourceChannel> finishListener, Object guard) {
        this.guard = guard;
        this.finishListener = finishListener;
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.delegate = delegate;
        stateUpdater.lazySet(this, contentLength);
        delegate.getReadSetter().set(ChannelListeners.delegatingChannelListener(this, this.readSetter));
        this.configurable = configurable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long val = this.enterRead();
        if (Bits.anyAreSet(val, 0x5000000000000000L) || Bits.allAreClear(val, MASK_COUNT)) {
            return 0L;
        }
        long res = 0L;
        try {
            long l = res = this.delegate.transferTo(position, Math.min(count, val), target);
            return l;
        }
        finally {
            this.exitRead(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long res;
        long val;
        block5: {
            if (count == 0L) {
                return 0L;
            }
            val = this.enterRead();
            if (Bits.anyAreSet(val, 0x5000000000000000L) || Bits.allAreClear(val, MASK_COUNT)) {
                return -1L;
            }
            res = 0L;
            try {
                if (!Bits.allAreSet(val, 0x4000000000000000L) && val != 0L) break block5;
                long l = -1L;
                this.exitRead(val, res == -1L ? val & MASK_COUNT : res);
                return l;
            }
            catch (Throwable throwable) {
                this.exitRead(val, res == -1L ? val & MASK_COUNT : res);
                throw throwable;
            }
        }
        long l = res = this.delegate.transferTo(Math.min(count, val), throughBuffer, target);
        this.exitRead(val, res == -1L ? val & MASK_COUNT : res);
        return l;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[FORLOOP], 1[TRYBLOCK], 4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendReads() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet(val, 0x7000000000000000L) || Bits.allAreClear(val, MASK_COUNT)) {
            return;
        }
        try {
            this.delegate.suspendReads();
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeReads() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet(val, 0x7000000000000000L) || Bits.allAreClear(val, MASK_COUNT)) {
            return;
        }
        try {
            if (val == 0L) {
                this.delegate.wakeupReads();
            } else {
                this.delegate.resumeReads();
            }
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.allAreClear(this.state, 0x4000000000000000L) && this.delegate.isReadResumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeupReads() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet(val, 0x7000000000000000L) || Bits.allAreClear(val, MASK_COUNT)) {
            return;
        }
        try {
            this.delegate.wakeupReads();
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownReads() throws IOException {
        long val = this.enterShutdownReads();
        if (Bits.allAreSet(val, 0x4000000000000000L)) {
            return;
        }
        this.exitShutdownReads(val);
    }

    @Override
    public void awaitReadable() throws IOException {
        long val = this.state;
        if (Bits.allAreSet(val, 0x4000000000000000L) || val == 0L) {
            return;
        }
        this.delegate.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        long val = this.state;
        if (Bits.allAreSet(val, 0x4000000000000000L) || val == 0L) {
            return;
        }
        this.delegate.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 0x4000000000000000L);
    }

    @Override
    public void close() throws IOException {
        this.shutdownReads();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.configurable && this.delegate.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.configurable ? (T)this.delegate.getOption(option) : null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.configurable ? (T)this.delegate.setOption(option, value) : null;
    }

    @Override
    public StreamSourceChannel getChannel(Object guard) {
        Object ourGuard = this.guard;
        if (ourGuard == null || guard == ourGuard) {
            return this.delegate;
        }
        return null;
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private long enterShutdownReads() {
        long newVal;
        long oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 0x4000000000000000L)) continue;
            return oldVal;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | 0x4000000000000000L | 0x2000000000000000L));
        return oldVal;
    }

    private void exitShutdownReads(long oldVal) {
        boolean wasFinished = Bits.allAreClear(oldVal, MASK_COUNT);
        boolean wasInSusRes = Bits.allAreSet(oldVal, 0x2000000000000000L);
        boolean wasEntered = Bits.allAreSet(oldVal, Long.MIN_VALUE);
        if (!wasInSusRes) {
            long newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
            }
            if (!wasEntered) {
                if (!wasFinished && Bits.allAreClear(newVal, MASK_COUNT)) {
                    this.callFinish();
                }
                this.callClosed();
            }
        }
    }

    private long enterSuspendResume() {
        long newVal;
        long oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 0x6000000000000000L)) continue;
            return oldVal;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | 0x2000000000000000L));
        return oldVal;
    }

    private void exitSuspendResume(long oldVal) {
        boolean wasFinished = Bits.allAreClear(oldVal, MASK_COUNT);
        boolean wasClosed = Bits.allAreClear(oldVal, 0x4000000000000000L);
        boolean wasEntered = Bits.allAreSet(oldVal, Long.MIN_VALUE);
        long newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
        }
        if (!wasEntered) {
            if (!wasFinished && Bits.allAreClear(newVal, MASK_COUNT)) {
                this.callFinish();
            }
            if (!wasClosed && Bits.allAreSet(newVal, 0x4000000000000000L)) {
                this.callClosed();
            }
        }
    }

    private long enterRead() {
        long newVal;
        long oldVal;
        do {
            if (Bits.allAreSet(oldVal = this.state, 0x4000000000000000L) || Bits.allAreClear(oldVal, MASK_COUNT)) {
                return oldVal;
            }
            if (!Bits.allAreSet(oldVal, Long.MIN_VALUE)) continue;
            throw new ConcurrentStreamChannelAccessException();
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | Long.MIN_VALUE));
        return oldVal;
    }

    private void exitRead(long oldVal, long consumed) {
        long newVal = oldVal - consumed;
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & Long.MAX_VALUE - consumed;
        }
        if (Bits.allAreSet(newVal, 0x4000000000000000L)) {
            this.callClosed();
        }
        if (Bits.anyAreSet(oldVal, MASK_COUNT) && Bits.allAreClear(newVal, MASK_COUNT)) {
            this.callFinish();
        }
    }

    private void callFinish() {
        ChannelListeners.invokeChannelListener(this, this.finishListener);
    }

    private void callClosed() {
        ChannelListeners.invokeChannelListener(this, this.closeSetter.get());
    }
}

