/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class NullStreamSinkChannel
implements StreamSinkChannel {
    private final XnioWorker worker;
    private final XnioExecutor executor;
    private volatile int state;
    private final ChannelListener.SimpleSetter<NullStreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<NullStreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();
    private static final AtomicIntegerFieldUpdater<NullStreamSinkChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NullStreamSinkChannel.class, "state");
    private static final int FLAG_ENTERED = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_RESUMED = 4;

    public NullStreamSinkChannel(XnioWorker worker, XnioExecutor executor) {
        this.worker = worker;
        this.executor = executor;
    }

    @Override
    public XnioWorker getWorker() {
        return this.worker;
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        int val = this.enterWrite();
        try {
            long l = Math.min(src.size() - position, count);
            return l;
        }
        finally {
            this.exitWrite(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        int val = this.enterWrite();
        try {
            long l = Channels.drain(source, count);
            return l;
        }
        finally {
            throughBuffer.clear();
            throughBuffer.position(0);
            this.exitWrite(val);
        }
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        int val = this.enterWrite();
        try {
            int n = src.remaining();
            return n;
        }
        finally {
            src.position(src.limit());
            this.exitWrite(val);
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        int val = this.enterWrite();
        try {
            long t = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer src = srcs[i];
                t += (long)src.remaining();
                src.position(src.limit());
            }
            long l = t;
            return l;
        }
        finally {
            this.exitWrite(val);
        }
    }

    @Override
    public void suspendWrites() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreClear(oldVal = this.state, 4) && !Bits.allAreSet(oldVal, 2)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & 0xFFFFFFFB));
    }

    @Override
    public void resumeWrites() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 6)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 4));
        this.executor.execute(ChannelListeners.getChannelListenerTask(this, this.writeSetter));
    }

    @Override
    public void wakeupWrites() {
        this.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        int state = this.state;
        return Bits.allAreSet(state, 4) && Bits.allAreClear(state, 2);
    }

    @Override
    public void shutdownWrites() throws IOException {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 2)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 2));
        this.writeSetter.set(null);
        ChannelListeners.invokeChannelListener(this, this.closeSetter.get());
    }

    @Override
    public void awaitWritable() throws IOException {
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
    }

    @Override
    public boolean flush() throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 2);
    }

    @Override
    public void close() throws IOException {
        this.shutdownWrites();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    private int enterWrite() throws ClosedChannelException {
        int newVal;
        int oldVal;
        do {
            if (Bits.allAreSet(oldVal = this.state, 1)) {
                throw new ConcurrentStreamChannelAccessException();
            }
            if (!Bits.allAreSet(oldVal, 2)) continue;
            throw new ClosedChannelException();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 1));
        return newVal;
    }

    private void exitWrite(int oldVal) {
        int newVal = oldVal & 0xFFFFFFFE;
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & 0xFFFFFFFE;
        }
    }
}

