/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class SpiltStreamSourceChannel
implements StreamSourceChannel {
    private final StreamSourceChannel delegate;
    private volatile int state;
    private volatile ChannelListener<? super SpiltStreamSourceChannel> readListener;
    private volatile ChannelListener<? super SpiltStreamSourceChannel> closeListener;
    private static final int FLAG_DELEGATE_CONFIG = 1;
    private static final int FLAG_CLOSED = 2;
    private static final AtomicIntegerFieldUpdater<SpiltStreamSourceChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(SpiltStreamSourceChannel.class, "state");

    public SpiltStreamSourceChannel(StreamSourceChannel delegate, boolean delegateConfig) {
        this.delegate = delegate;
        delegate.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                ChannelListeners.invokeChannelListener(SpiltStreamSourceChannel.this, SpiltStreamSourceChannel.this.readListener);
            }
        });
        this.state = delegateConfig ? 1 : 0;
    }

    public SpiltStreamSourceChannel(StreamSourceChannel delegate) {
        this(delegate, false);
    }

    public void setReadListener(ChannelListener<? super SpiltStreamSourceChannel> readListener) {
        this.readListener = readListener;
    }

    public void setCloseListener(ChannelListener<? super SpiltStreamSourceChannel> closeListener) {
        this.closeListener = closeListener;
    }

    public ChannelListener.Setter<? extends SpiltStreamSourceChannel> getReadSetter() {
        return new ChannelListener.Setter<SpiltStreamSourceChannel>(){

            @Override
            public void set(ChannelListener<? super SpiltStreamSourceChannel> listener) {
                SpiltStreamSourceChannel.this.setReadListener(listener);
            }
        };
    }

    public ChannelListener.Setter<? extends SpiltStreamSourceChannel> getCloseSetter() {
        return new ChannelListener.Setter<SpiltStreamSourceChannel>(){

            @Override
            public void set(ChannelListener<? super SpiltStreamSourceChannel> listener) {
                SpiltStreamSourceChannel.this.setCloseListener(listener);
            }
        };
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.delegate.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.delegate.transferTo(count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.delegate.read(dsts);
    }

    @Override
    public void suspendReads() {
        this.delegate.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.delegate.resumeReads();
    }

    @Override
    public void wakeupReads() {
        this.delegate.wakeupReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.delegate.isReadResumed();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.delegate.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return Bits.allAreSet(this.state, 1) ? this.delegate.supportsOption(option) : false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return Bits.allAreSet(this.state, 1) ? (T)this.delegate.getOption(option) : null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return Bits.allAreSet(this.state, 1) ? (T)this.delegate.setOption(option, value) : null;
    }

    @Override
    public void shutdownReads() throws IOException {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 2)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 2));
        this.delegate.shutdownReads();
        ChannelListeners.invokeChannelListener(this, this.closeListener);
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 2);
    }

    @Override
    public void close() throws IOException {
        this.shutdownReads();
    }
}

