/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FinishedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.TcpAcceptor;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.TcpServer;
import org.jboss.xnio.UdpServer;
import org.jboss.xnio.Xnio;
import org.jboss.xnio.XnioConfiguration;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.OneWayPipeConnectionMBean;
import org.jboss.xnio.management.PipeConnectionMBean;
import org.jboss.xnio.management.PipeServerMBean;
import org.jboss.xnio.management.PipeSinkServerMBean;
import org.jboss.xnio.management.PipeSourceServerMBean;
import org.jboss.xnio.management.TcpConnectionMBean;
import org.jboss.xnio.management.TcpServerMBean;
import org.jboss.xnio.management.UdpServerMBean;
import org.jboss.xnio.nio.BioUdpServer;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioOneWayPipeConnection;
import org.jboss.xnio.nio.NioPipeConnection;
import org.jboss.xnio.nio.NioSelectorRunnable;
import org.jboss.xnio.nio.NioTcpAcceptor;
import org.jboss.xnio.nio.NioTcpConnector;
import org.jboss.xnio.nio.NioTcpServer;
import org.jboss.xnio.nio.NioUdpServer;
import org.jboss.xnio.nio.NioXnioConfiguration;
import org.jboss.xnio.nio.SelectorTask;
import org.jboss.xnio.nio.SynchronousHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioXnio
extends Xnio {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio");
    private final Object lock = new Object();
    private volatile boolean closed;
    private final List<NioSelectorRunnable> readers = new ArrayList<NioSelectorRunnable>();
    private final List<NioSelectorRunnable> writers = new ArrayList<NioSelectorRunnable>();
    private final List<NioSelectorRunnable> connectors = new ArrayList<NioSelectorRunnable>();
    private final Set<Closeable> managedSet = new HashSet<Closeable>();
    private final AtomicInteger loadSequence = new AtomicInteger();
    private int selectorCacheCount;
    private final Selector[] cache;
    private final Lock selectorCacheLock = new ReentrantLock();

    public static Xnio create(NioXnioConfiguration configuration) throws IOException {
        return NioXnio.doCreate(configuration);
    }

    private static NioXnio doCreate(NioXnioConfiguration configuration) throws IOException {
        try {
            return AccessController.doPrivileged(new CreateAction(configuration));
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable cause) {
                throw new RuntimeException("Unexpected exception", cause);
            }
        }
    }

    public static Xnio create() throws IOException {
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setReadSelectorThreads(1);
        configuration.setWriteSelectorThreads(1);
        configuration.setConnectSelectorThreads(1);
        return NioXnio.doCreate(configuration);
    }

    public static Xnio create(int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setReadSelectorThreads(readSelectorThreads);
        configuration.setWriteSelectorThreads(writeSelectorThreads);
        configuration.setConnectSelectorThreads(connectSelectorThreads);
        return NioXnio.doCreate(configuration);
    }

    public static Xnio create(Executor handlerExecutor, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        if (handlerExecutor == null) {
            throw new NullPointerException("handlerExecutor is null");
        }
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setExecutor(handlerExecutor);
        configuration.setReadSelectorThreads(readSelectorThreads);
        configuration.setWriteSelectorThreads(writeSelectorThreads);
        configuration.setConnectSelectorThreads(connectSelectorThreads);
        return NioXnio.doCreate(configuration);
    }

    public static Xnio create(Executor handlerExecutor, ThreadFactory selectorThreadFactory, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        if (handlerExecutor == null) {
            throw new NullPointerException("handlerExecutor is null");
        }
        if (selectorThreadFactory == null) {
            throw new NullPointerException("selectorThreadFactory is null");
        }
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setExecutor(handlerExecutor);
        configuration.setSelectorThreadFactory(selectorThreadFactory);
        configuration.setReadSelectorThreads(readSelectorThreads);
        configuration.setWriteSelectorThreads(writeSelectorThreads);
        configuration.setConnectSelectorThreads(connectSelectorThreads);
        return NioXnio.doCreate(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NioXnio(NioXnioConfiguration configuration) throws IOException {
        super((XnioConfiguration)configuration);
        String providerClassName = SelectorProvider.provider().getClass().getCanonicalName();
        if ("sun.nio.ch.PollSelectorProvider".equals(providerClassName)) {
            log.warn("The currently defined selector provider class (%s) is not supported for use with XNIO", (Object)providerClassName);
        }
        log.trace("Starting up with selector provider %s", (Object)providerClassName);
        ThreadFactory selectorThreadFactory = configuration.getSelectorThreadFactory();
        Executor executor = configuration.getExecutor();
        int readSelectorThreads = configuration.getReadSelectorThreads();
        int writeSelectorThreads = configuration.getWriteSelectorThreads();
        int connectSelectorThreads = configuration.getConnectSelectorThreads();
        int selectorCacheSize = configuration.getSelectorCacheSize();
        if (selectorThreadFactory == null) {
            selectorThreadFactory = Executors.defaultThreadFactory();
        }
        if (readSelectorThreads < 1) {
            throw new IllegalArgumentException("readSelectorThreads must be >= 1");
        }
        if (writeSelectorThreads < 1) {
            throw new IllegalArgumentException("writeSelectorThreads must be >= 1");
        }
        if (connectSelectorThreads < 1) {
            throw new IllegalArgumentException("connectSelectorThreads must be >= 1");
        }
        if (selectorCacheSize < 0) {
            throw new IllegalArgumentException("selectorCacheSize must be >= 0");
        }
        this.cache = new Selector[selectorCacheSize];
        Object object = this.lock;
        synchronized (object) {
            int i;
            for (i = 0; i < readSelectorThreads; ++i) {
                this.readers.add(new NioSelectorRunnable());
            }
            for (i = 0; i < writeSelectorThreads; ++i) {
                this.writers.add(new NioSelectorRunnable());
            }
            for (i = 0; i < connectSelectorThreads; ++i) {
                this.connectors.add(new NioSelectorRunnable());
            }
            for (NioSelectorRunnable runnable : this.readers) {
                selectorThreadFactory.newThread(runnable).start();
            }
            for (NioSelectorRunnable runnable : this.writers) {
                selectorThreadFactory.newThread(runnable).start();
            }
            for (NioSelectorRunnable runnable : this.connectors) {
                selectorThreadFactory.newThread(runnable).start();
            }
            log.debug("Creating NioXnio instance using %d read threads, %d write threads, %d connect threads", (Object)readSelectorThreads, (Object)writeSelectorThreads, (Object)connectSelectorThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpServer createTcpServer(Executor executor, ChannelListener<? super TcpChannel> openHandler, OptionMap optionMap) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (openHandler == null) {
            throw new NullPointerException("openHandler is null");
        }
        if (optionMap == null) {
            throw new NullPointerException("optionMap is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return NioTcpServer.create(this, executor, openHandler, optionMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpConnector createTcpConnector(Executor executor, OptionMap optionMap) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (optionMap == null) {
            throw new NullPointerException("optionMap is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return NioTcpConnector.create(this, executor, optionMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UdpServer createUdpServer(Executor executor, ChannelListener<? super UdpChannel> openHandler, OptionMap optionMap) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (openHandler == null) {
            throw new NullPointerException("openHandler is null");
        }
        if (optionMap == null) {
            throw new NullPointerException("optionMap is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            if (optionMap.contains(Options.MULTICAST) && ((Boolean)optionMap.get(Options.MULTICAST)).booleanValue()) {
                return new BioUdpServer(this, executor, openHandler, optionMap);
            }
            return new NioUdpServer(this, executor, openHandler, optionMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSource<? extends StreamChannel> createPipeServer(Executor executor, final ChannelListener<? super StreamChannel> leftOpenListener) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (leftOpenListener == null) {
            throw new NullPointerException("openHandler is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new ChannelSource<StreamChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IoFuture<? extends StreamChannel> open(ChannelListener<? super StreamChannel> rightOpenListener) {
                    Object object = NioXnio.this.lock;
                    synchronized (object) {
                        NioPipeConnection nioPipeConnection;
                        if (NioXnio.this.closed) {
                            throw NioXnio.notOpen();
                        }
                        try {
                            nioPipeConnection = new NioPipeConnection(NioXnio.this);
                            if (!IoUtils.invokeChannelListener((Channel)((Object)nioPipeConnection.getLeftSide()), (ChannelListener)leftOpenListener) || !IoUtils.invokeChannelListener((Channel)((Object)nioPipeConnection.getRightSide()), rightOpenListener)) {
                                IoUtils.safeClose((Closeable)nioPipeConnection);
                            }
                        }
                        catch (IOException e) {
                            return new FailedIoFuture(e);
                        }
                        return new FinishedIoFuture((Object)nioPipeConnection.getLeftSide());
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSource<? extends StreamSourceChannel> createPipeSourceServer(Executor executor, final ChannelListener<? super StreamSinkChannel> sinkOpenListener) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (sinkOpenListener == null) {
            throw new NullPointerException("sinkOpenListener is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new ChannelSource<StreamSourceChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IoFuture<? extends StreamSourceChannel> open(ChannelListener<? super StreamSourceChannel> sourceOpenListener) {
                    Object object = NioXnio.this.lock;
                    synchronized (object) {
                        NioOneWayPipeConnection nioPipeConnection;
                        if (NioXnio.this.closed) {
                            throw NioXnio.notOpen();
                        }
                        try {
                            nioPipeConnection = new NioOneWayPipeConnection(NioXnio.this);
                            if (!IoUtils.invokeChannelListener((Channel)((Object)nioPipeConnection.getSinkSide()), (ChannelListener)sinkOpenListener) || !IoUtils.invokeChannelListener((Channel)((Object)nioPipeConnection.getSourceSide()), sourceOpenListener)) {
                                IoUtils.safeClose((Closeable)nioPipeConnection);
                            }
                        }
                        catch (IOException e) {
                            return new FailedIoFuture(e);
                        }
                        return new FinishedIoFuture((Object)nioPipeConnection.getSourceSide());
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSource<? extends StreamSinkChannel> createPipeSinkServer(Executor executor, final ChannelListener<? super StreamSourceChannel> sourceOpenListener) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (sourceOpenListener == null) {
            throw new NullPointerException("sourceOpenListener is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new ChannelSource<StreamSinkChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IoFuture<? extends StreamSinkChannel> open(ChannelListener<? super StreamSinkChannel> sinkOpenListener) {
                    Object object = NioXnio.this.lock;
                    synchronized (object) {
                        NioOneWayPipeConnection nioPipeConnection;
                        if (NioXnio.this.closed) {
                            throw NioXnio.notOpen();
                        }
                        try {
                            nioPipeConnection = new NioOneWayPipeConnection(NioXnio.this);
                            if (!IoUtils.invokeChannelListener((Channel)((Object)nioPipeConnection.getSourceSide()), (ChannelListener)sourceOpenListener) || !IoUtils.invokeChannelListener((Channel)((Object)nioPipeConnection.getSinkSide()), sinkOpenListener)) {
                                IoUtils.safeClose((Closeable)nioPipeConnection);
                            }
                        }
                        catch (IOException e) {
                            return new FailedIoFuture(e);
                        }
                        return new FinishedIoFuture((Object)nioPipeConnection.getSinkSide());
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<? extends Closeable> createPipeConnection(Executor executor, ChannelListener<? super StreamChannel> leftHandler, ChannelListener<? super StreamChannel> rightHandler) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (leftHandler == null) {
            throw new NullPointerException("leftHandler is null");
        }
        if (rightHandler == null) {
            throw new NullPointerException("rightHandler is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            try {
                NioPipeConnection connection = new NioPipeConnection(this);
                if (!IoUtils.invokeChannelListener((Channel)((Object)connection.getLeftSide()), leftHandler) || !IoUtils.invokeChannelListener((Channel)((Object)connection.getRightSide()), rightHandler)) {
                    IoUtils.safeClose((Closeable)connection);
                }
                return new FinishedIoFuture((Object)connection);
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<? extends Closeable> createOneWayPipeConnection(Executor executor, ChannelListener<? super StreamSourceChannel> sourceHandler, ChannelListener<? super StreamSinkChannel> sinkHandler) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (sourceHandler == null) {
            throw new NullPointerException("sourceHandler is null");
        }
        if (sinkHandler == null) {
            throw new NullPointerException("sinkHandler is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            try {
                NioOneWayPipeConnection connection = new NioOneWayPipeConnection(this);
                if (!IoUtils.invokeChannelListener((Channel)((Object)connection.getSourceSide()), sourceHandler) || !IoUtils.invokeChannelListener((Channel)((Object)connection.getSinkSide()), sinkHandler)) {
                    IoUtils.safeClose((Closeable)connection);
                }
                return new FinishedIoFuture((Object)connection);
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpAcceptor createTcpAcceptor(Executor executor, OptionMap optionMap) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (optionMap == null) {
            throw new NullPointerException("optionMap is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return NioTcpAcceptor.create(this, executor, optionMap);
        }
    }

    public void awaken(Thread targetThread) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                Iterator<Closeable> it = this.managedSet.iterator();
                while (it.hasNext()) {
                    Closeable closeable = it.next();
                    it.remove();
                    IoUtils.safeClose((Closeable)closeable);
                }
                for (NioSelectorRunnable runnable : this.readers) {
                    runnable.shutdown();
                }
                for (NioSelectorRunnable runnable : this.writers) {
                    runnable.shutdown();
                }
                for (NioSelectorRunnable runnable : this.connectors) {
                    runnable.shutdown();
                }
                this.readers.clear();
                this.writers.clear();
                this.connectors.clear();
            }
        }
    }

    public String toString() {
        return "NIO " + super.toString();
    }

    protected Closeable registerMBean(TcpServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(TcpConnectionMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(UdpServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(OneWayPipeConnectionMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeConnectionMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeSourceServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeSinkServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    private NioHandle doAdd(final SelectableChannel channel, List<NioSelectorRunnable> runnableSet, final Runnable handler, final boolean oneshot, final Executor executor) throws IOException {
        NioSelectorRunnable nioSelectorRunnable;
        if (this.closed) {
            throw new ClosedChannelException();
        }
        final SynchronousHolder holder = new SynchronousHolder();
        final NioSelectorRunnable actualSelectorRunnable = nioSelectorRunnable = runnableSet.get(this.loadSequence.getAndIncrement() % runnableSet.size());
        nioSelectorRunnable.runTask(new SelectorTask(){

            public void run(Selector selector) {
                try {
                    SelectionKey selectionKey = channel.register(selector, 0);
                    NioHandle handle = new NioHandle(selectionKey, actualSelectorRunnable, handler, executor, oneshot);
                    selectionKey.attach(handle);
                    holder.set(handle);
                }
                catch (ClosedChannelException e) {
                    holder.setProblem(e);
                }
            }
        });
        return (NioHandle)holder.get();
    }

    NioHandle addConnectHandler(SelectableChannel channel, Runnable handler, boolean oneshot) throws IOException {
        return this.doAdd(channel, this.connectors, handler, oneshot, this.getExecutor());
    }

    NioHandle addConnectHandler(SelectableChannel channel, Runnable handler, boolean oneshot, Executor executor) throws IOException {
        return this.doAdd(channel, this.connectors, handler, oneshot, executor);
    }

    NioHandle addReadHandler(SelectableChannel channel, Runnable handler) throws IOException {
        return this.doAdd(channel, this.readers, handler, true, this.getExecutor());
    }

    NioHandle addReadHandler(SelectableChannel channel, Runnable handler, Executor executor) throws IOException {
        return this.doAdd(channel, this.readers, handler, true, executor);
    }

    NioHandle addWriteHandler(SelectableChannel channel, Runnable handler) throws IOException {
        return this.doAdd(channel, this.writers, handler, true, this.getExecutor());
    }

    NioHandle addWriteHandler(SelectableChannel channel, Runnable handler, Executor executor) throws IOException {
        return this.doAdd(channel, this.writers, handler, true, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addManaged(Closeable closeable) {
        Object object = this.lock;
        synchronized (object) {
            this.managedSet.add(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManaged(Closeable closeable) {
        Object object = this.lock;
        synchronized (object) {
            this.managedSet.remove(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Selector getSelector() throws IOException {
        this.selectorCacheLock.lock();
        try {
            int cnt = this.selectorCacheCount;
            if (cnt > 0) {
                Selector[] cache = this.cache;
                try {
                    Selector selector = cache[cnt - 1];
                    return selector;
                }
                finally {
                    this.selectorCacheCount = cnt - 1;
                    cache[this.selectorCacheCount] = null;
                }
            }
            Selector selector = Selector.open();
            return selector;
        }
        finally {
            this.selectorCacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnSelector(Selector selector) {
        this.selectorCacheLock.lock();
        try {
            int cnt = this.selectorCacheCount;
            if (cnt == this.cache.length) {
                IoUtils.safeClose((Selector)selector);
            } else {
                this.selectorCacheCount = cnt + 1;
                this.cache[cnt] = selector;
            }
        }
        finally {
            this.selectorCacheLock.unlock();
        }
    }

    private static IllegalStateException notOpen() {
        return new IllegalStateException("XNIO provider not open");
    }

    static {
        log.info("XNIO NIO Implementation Version 2.0.0.CR4");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateAction
    implements PrivilegedExceptionAction<NioXnio> {
        private final NioXnioConfiguration configuration;

        public CreateAction(NioXnioConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public NioXnio run() throws IOException {
            return new NioXnio(this.configuration);
        }
    }
}

