/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SynchronousHolder<T, E extends Throwable> {
    private T held;
    private E problem;
    private boolean set = false;

    SynchronousHolder() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get() throws E {
        boolean intr = false;
        try {
            SynchronousHolder synchronousHolder = this;
            synchronized (synchronousHolder) {
                while (true) {
                    if (this.problem != null) {
                        throw this.problem;
                    }
                    if (this.set) {
                        T t = this.held;
                        return t;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        SynchronousHolder synchronousHolder = this;
        synchronized (synchronousHolder) {
            this.held = value;
            this.set = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProblem(E problem) {
        SynchronousHolder synchronousHolder = this;
        synchronized (synchronousHolder) {
            this.problem = problem;
            this.notify();
        }
    }
}

