/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

abstract class AbstractNioStreamChannel<C extends AbstractNioStreamChannel<C>>
implements StreamChannel {
    private static final String FQCN = AbstractNioStreamChannel.class.getName();
    private final NioXnioWorker worker;
    private volatile NioHandle<C> readHandle;
    private volatile NioHandle<C> writeHandle;
    private final ChannelListener.SimpleSetter<C> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> closeSetter = new ChannelListener.SimpleSetter();

    AbstractNioStreamChannel(NioXnioWorker worker) throws ClosedChannelException {
        this.worker = worker;
    }

    void start() throws ClosedChannelException {
        WorkerThread readThread = this.worker.chooseOptional(false);
        WorkerThread writeThread = this.worker.chooseOptional(true);
        this.readHandle = readThread == null ? null : readThread.addChannel((AbstractSelectableChannel)((Object)this.getReadChannel()), this.typed(), 0, this.readSetter);
        this.writeHandle = writeThread == null ? null : writeThread.addChannel((AbstractSelectableChannel)((Object)this.getWriteChannel()), this.typed(), 0, this.writeSetter);
    }

    protected abstract ScatteringByteChannel getReadChannel();

    protected abstract GatheringByteChannel getWriteChannel();

    public XnioWorker getWorker() {
        return this.worker;
    }

    public final ChannelListener.Setter<? extends C> getReadSetter() {
        return this.readSetter;
    }

    public final ChannelListener.Setter<? extends C> getWriteSetter() {
        return this.writeSetter;
    }

    public final ChannelListener.Setter<? extends C> getCloseSetter() {
        return this.closeSetter;
    }

    public final void suspendReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Suspend reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle != null) {
            readHandle.suspend();
        }
    }

    public final void resumeReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Resume reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.resume(1);
    }

    public void wakeupReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Wake up reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.getWorkerThread().execute(ChannelListeners.getChannelListenerTask(this.typed(), (ChannelListener)this.readSetter.get()));
    }

    public final void suspendWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Suspend writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle != null) {
            writeHandle.resume(0);
        }
    }

    public final void resumeWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Resume writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.resume(4);
    }

    public void wakeupWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Wake up writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.getWorkerThread().execute(ChannelListeners.getChannelListenerTask(this.typed(), (ChannelListener)this.writeSetter.get()));
    }

    public final void awaitReadable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getReadChannel()), 1);
    }

    public final void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getReadChannel()), 1, time, timeUnit);
    }

    public final void awaitWritable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getWriteChannel()), 4);
    }

    public final void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getWriteChannel()), 4, time, timeUnit);
    }

    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this.getReadChannel(), position, count);
    }

    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this.getWriteChannel());
    }

    public boolean flush() throws IOException {
        return true;
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.getReadChannel().read(dst);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.getReadChannel().read(dsts);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.getReadChannel().read(dsts, offset, length);
    }

    public int write(ByteBuffer src) throws IOException {
        return this.getWriteChannel().write(src);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.getWriteChannel().write(srcs);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.getWriteChannel().write(srcs, offset, length);
    }

    private C typed() {
        return (C)this;
    }

    protected void invokeCloseHandler() {
        ChannelListeners.invokeChannelListener(this.typed(), (ChannelListener)this.closeSetter.get());
    }

    protected void cancelWriteKey() {
        if (this.writeHandle != null) {
            this.writeHandle.cancelKey();
        }
    }

    protected void cancelReadKey() {
        if (this.readHandle != null) {
            this.readHandle.cancelKey();
        }
    }

    NioHandle<C> getReadHandle() {
        return this.readHandle;
    }

    NioHandle<C> getWriteHandle() {
        return this.writeHandle;
    }
}

