/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ClosedWorkerException;
import org.xnio.FailedIoFuture;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.nio.BioMulticastUdpChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioPipeChannel;
import org.xnio.nio.NioSetter;
import org.xnio.nio.NioTcpChannel;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.NioUdpChannel;
import org.xnio.nio.NioXnio;
import org.xnio.nio.WorkerThread;

final class NioXnioWorker
extends XnioWorker {
    private static final int CLOSE_REQ = Integer.MIN_VALUE;
    private static final int CLOSE_COMP = 0x40000000;
    private volatile int state = 1;
    private final WorkerThread[] readWorkers;
    private final WorkerThread[] writeWorkers;
    private static final AtomicIntegerFieldUpdater<NioXnioWorker> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NioXnioWorker.class, "state");
    private static final WorkerThread[] NO_WORKERS = new WorkerThread[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioXnioWorker(NioXnio xnio, ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException {
        super((Xnio)xnio, threadGroup, optionMap, terminationTask);
        int readCount = optionMap.get(Options.WORKER_READ_THREADS, 1);
        if (readCount < 0) {
            throw new IllegalArgumentException("Worker read thread count must be >= 0");
        }
        int writeCount = optionMap.get(Options.WORKER_WRITE_THREADS, 1);
        if (writeCount < 0) {
            throw new IllegalArgumentException("Worker write thread count must be >= 0");
        }
        long workerStackSize = optionMap.get(Options.STACK_SIZE, 0L);
        if (workerStackSize < 0L) {
            throw new IllegalArgumentException("Worker stack size must be >= 0");
        }
        String workerName = this.getName();
        WorkerThread[] readWorkers = new WorkerThread[readCount];
        WorkerThread[] writeWorkers = new WorkerThread[writeCount];
        boolean ok = false;
        try {
            int i;
            for (i = 0; i < readCount; ++i) {
                readWorkers[i] = new WorkerThread(this, Selector.open(), String.format("%s read-%d", workerName, i + 1), threadGroup, workerStackSize);
            }
            for (i = 0; i < writeCount; ++i) {
                writeWorkers[i] = new WorkerThread(this, Selector.open(), String.format("%s write-%d", workerName, i + 1), threadGroup, workerStackSize);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WorkerThread worker : readWorkers) {
                    if (worker == null) continue;
                    IoUtils.safeClose((Selector)worker.getSelector());
                }
                for (WorkerThread worker : writeWorkers) {
                    if (worker == null) continue;
                    IoUtils.safeClose((Selector)worker.getSelector());
                }
            }
        }
        this.readWorkers = readWorkers;
        this.writeWorkers = writeWorkers;
    }

    void start() {
        for (WorkerThread worker : this.readWorkers) {
            this.openResourceUnconditionally();
            worker.start();
        }
        for (WorkerThread worker : this.writeWorkers) {
            this.openResourceUnconditionally();
            worker.start();
        }
    }

    WorkerThread choose() {
        WorkerThread[] write = this.writeWorkers;
        WorkerThread[] read = this.readWorkers;
        int writeLength = write.length;
        int readLength = read.length;
        if (writeLength == 0) {
            return this.choose(false);
        }
        if (readLength == 0) {
            return this.choose(true);
        }
        Random random = IoUtils.getThreadLocalRandom();
        int idx = random.nextInt(writeLength + readLength);
        return idx >= readLength ? write[idx - readLength] : read[idx];
    }

    WorkerThread chooseOptional(boolean write) {
        WorkerThread[] orig = write ? this.writeWorkers : this.readWorkers;
        int length = orig.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return orig[0];
        }
        Random random = IoUtils.getThreadLocalRandom();
        return orig[random.nextInt(length)];
    }

    WorkerThread choose(boolean write) {
        WorkerThread result = this.chooseOptional(write);
        if (result == null) {
            throw new IllegalArgumentException("No threads configured");
        }
        return result;
    }

    WorkerThread[] choose(int count, boolean write) {
        HashSet<Object> set;
        if (count == 0) {
            return NO_WORKERS;
        }
        WorkerThread[] orig = write ? this.writeWorkers : this.readWorkers;
        int length = orig.length;
        if (length == 0) {
            throw new IllegalArgumentException("No threads configured");
        }
        if (count == length) {
            return orig;
        }
        WorkerThread[] result = new WorkerThread[count];
        Random random = IoUtils.getThreadLocalRandom();
        if (count == 1) {
            result[0] = orig[random.nextInt(length)];
            return result;
        }
        if (length < 32) {
            int bits = 0;
            while (Integer.bitCount(bits |= 1 << random.nextInt(length)) < count) {
            }
            for (int i = 0; i < count; ++i) {
                int bit = Integer.numberOfTrailingZeros(bits);
                result[i] = orig[bit];
                bits ^= Integer.lowestOneBit(bits);
            }
            return result;
        }
        if (length < 64) {
            long bits = 0L;
            while (Long.bitCount(bits |= 1L << (int)((long)random.nextInt(length))) < count) {
            }
            for (int i = 0; i < count; ++i) {
                int bit = Long.numberOfTrailingZeros(bits);
                result[i] = orig[bit];
                bits ^= Long.lowestOneBit(bits);
            }
            return result;
        }
        if (count >= length >> 1) {
            set = new HashSet<WorkerThread>(Arrays.asList(orig));
            while (set.size() > count) {
                set.remove(orig[random.nextInt(length)]);
            }
        } else {
            set = new HashSet(length);
            while (set.size() < count) {
                set.add(orig[random.nextInt(length)]);
            }
        }
        return set.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        boolean ok = false;
        ServerSocketChannel channel = ServerSocketChannel.open();
        try {
            channel.configureBlocking(false);
            channel.socket().bind(bindAddress);
            NioTcpServer server = new NioTcpServer(this, channel, optionMap);
            ChannelListener.SimpleSetter<NioTcpServer> setter = server.getAcceptSetter();
            setter.set(acceptListener);
            ok = true;
            NioTcpServer nioTcpServer = server;
            return nioTcpServer;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    protected IoFuture<ConnectedStreamChannel> connectTcpStream(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        try {
            final SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(bindAddress);
            final NioTcpChannel tcpChannel = new NioTcpChannel(this, channel);
            final NioHandle connectHandle = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false) ? tcpChannel.getWriteHandle() : tcpChannel.getReadHandle();
            ChannelListeners.invokeChannelListener((Channel)tcpChannel.getBoundChannel(), bindListener);
            if (channel.connect(destinationAddress)) {
                connectHandle.getWorkerThread().execute(ChannelListeners.getChannelListenerTask((Channel)((Object)tcpChannel), openListener));
                return new FinishedIoFuture((Object)tcpChannel);
            }
            ChannelListener.SimpleSetter setter = connectHandle.getHandlerSetter();
            final FutureResult futureResult = new FutureResult();
            setter.set((ChannelListener)new ChannelListener<NioTcpChannel>(){

                public void handleEvent(NioTcpChannel channel2) {
                    SocketChannel socketChannel = channel2.getReadChannel();
                    try {
                        if (socketChannel.finishConnect()) {
                            connectHandle.suspend();
                            connectHandle.getHandlerSetter().set(null);
                            futureResult.setResult((Object)tcpChannel);
                            ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), (ChannelListener)openListener);
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)((Object)channel2));
                        futureResult.setException(e);
                    }
                }

                public String toString() {
                    return "Connection finisher for " + channel;
                }
            });
            futureResult.addCancelHandler(new Cancellable(){

                public Cancellable cancel() {
                    if (futureResult.setCancelled()) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                    return this;
                }

                public String toString() {
                    return "Cancel handler for " + channel;
                }
            });
            connectHandle.resume(8);
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    protected IoFuture<ConnectedStreamChannel> acceptTcpStream(InetSocketAddress destination, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        WorkerThread connectThread = this.choose(optionMap.get(Options.WORKER_ESTABLISH_WRITING, false));
        try {
            final ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(destination);
            final NioSetter closeSetter = new NioSetter();
            ChannelListeners.invokeChannelListener((Channel)new BoundChannel(){

                public XnioWorker getWorker() {
                    return NioXnioWorker.this;
                }

                public SocketAddress getLocalAddress() {
                    return channel.socket().getLocalSocketAddress();
                }

                public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                    SocketAddress address = this.getLocalAddress();
                    return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
                }

                public ChannelListener.Setter<? extends BoundChannel> getCloseSetter() {
                    return closeSetter;
                }

                public boolean isOpen() {
                    return channel.isOpen();
                }

                public boolean supportsOption(Option<?> option) {
                    return false;
                }

                public <T> T getOption(Option<T> option) throws IOException {
                    return null;
                }

                public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                    return null;
                }

                public void close() throws IOException {
                    channel.close();
                }

                public String toString() {
                    return String.format("TCP acceptor bound channel (NIO) <%h>", this);
                }
            }, bindListener);
            SocketChannel accepted = channel.accept();
            if (accepted != null) {
                IoUtils.safeClose((Closeable)channel);
                NioTcpChannel tcpChannel = new NioTcpChannel(this, accepted);
                ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), openListener);
                return new FinishedIoFuture((Object)tcpChannel);
            }
            ChannelListener.SimpleSetter setter = new ChannelListener.SimpleSetter();
            final FutureResult futureResult = new FutureResult();
            final NioHandle<ServerSocketChannel> handle = connectThread.addChannel(channel, channel, 0, setter);
            setter.set((ChannelListener)new ChannelListener<ServerSocketChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleEvent(ServerSocketChannel channel2) {
                    SocketChannel accepted;
                    try {
                        accepted = channel2.accept();
                        if (accepted == null) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel2);
                        handle.cancelKey();
                        futureResult.setException(e);
                        return;
                    }
                    boolean ok = false;
                    try {
                        handle.cancelKey();
                        IoUtils.safeClose((Closeable)channel2);
                        try {
                            accepted.configureBlocking(false);
                            NioTcpChannel tcpChannel = new NioTcpChannel(NioXnioWorker.this, accepted);
                            futureResult.setResult((Object)tcpChannel);
                            ok = true;
                            ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), (ChannelListener)openListener);
                        }
                        catch (IOException e) {
                            futureResult.setException(e);
                            if (!ok) {
                                IoUtils.safeClose((Closeable)accepted);
                            }
                            return;
                        }
                    }
                    finally {
                        if (!ok) {
                            IoUtils.safeClose((Closeable)accepted);
                        }
                    }
                }

                public String toString() {
                    return "Accepting finisher for " + channel;
                }
            });
            handle.resume(16);
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        if (!NioXnio.NIO2 && optionMap.get(Options.MULTICAST, false)) {
            MulticastSocket socket = new MulticastSocket(bindAddress);
            BioMulticastUdpChannel channel = new BioMulticastUdpChannel((XnioWorker)this, optionMap.get(Options.SEND_BUFFER, 8192), optionMap.get(Options.RECEIVE_BUFFER, 8192), socket, this.chooseOptional(false), this.chooseOptional(true));
            channel.open();
            ChannelListeners.invokeChannelListener((Channel)((Object)channel), bindListener);
            return channel;
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        channel.socket().bind(bindAddress);
        NioUdpChannel udpChannel = new NioUdpChannel(this, channel);
        ChannelListeners.invokeChannelListener((Channel)((Object)udpChannel), bindListener);
        return udpChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPipe(ChannelListener<? super StreamChannel> leftOpenListener, ChannelListener<? super StreamChannel> rightOpenListener, OptionMap optionMap) throws IOException {
        boolean ok = false;
        Pipe in = Pipe.open();
        try {
            Pipe out = Pipe.open();
            try {
                NioPipeChannel outbound = new NioPipeChannel(this, in.sink(), out.source());
                try {
                    NioPipeChannel inbound = new NioPipeChannel(this, out.sink(), in.source());
                    try {
                        boolean establishWriting = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false);
                        XnioExecutor outboundExec = establishWriting ? outbound.getWriteThread() : outbound.getReadThread();
                        XnioExecutor inboundExec = establishWriting ? inbound.getWriteThread() : inbound.getReadThread();
                        outboundExec.execute(ChannelListeners.getChannelListenerTask((Channel)((Object)outbound), leftOpenListener));
                        inboundExec.execute(ChannelListeners.getChannelListenerTask((Channel)((Object)inbound), rightOpenListener));
                        ok = true;
                    }
                    catch (RejectedExecutionException e) {
                        throw new IOException("Failed to execute open task(s)", e);
                    }
                    finally {
                        if (!ok) {
                            IoUtils.safeClose((Closeable)((Object)inbound));
                        }
                    }
                }
                finally {
                    if (!ok) {
                        IoUtils.safeClose((Closeable)((Object)outbound));
                    }
                }
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose((Closeable)out.sink());
                    IoUtils.safeClose((Closeable)out.source());
                }
            }
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)in.sink());
                IoUtils.safeClose((Closeable)in.source());
            }
        }
    }

    public boolean isShutdown() {
        return (this.state & Integer.MIN_VALUE) != 0;
    }

    public boolean isTerminated() {
        return (this.state & 0x40000000) != 0;
    }

    void openResourceUnconditionally() {
        int oldState = stateUpdater.getAndIncrement(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)oldState, (Object)(oldState + 1));
        }
    }

    void openResource() throws ClosedWorkerException {
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) == 0) continue;
            throw new ClosedWorkerException("Worker is shutting down");
        } while (!stateUpdater.compareAndSet(this, oldState, oldState + 1));
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)oldState, (Object)(oldState + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResource() {
        int oldState = stateUpdater.decrementAndGet(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)(oldState + 1), (Object)oldState);
        }
        while (oldState == Integer.MIN_VALUE) {
            if (stateUpdater.compareAndSet(this, Integer.MIN_VALUE, -1073741824)) {
                Log.log.tracef("CAS %s %08x -> %08x (close complete)", (Object)this, (Object)Integer.MIN_VALUE, (Object)-1073741824);
                NioXnioWorker nioXnioWorker = this;
                synchronized (nioXnioWorker) {
                    ((Object)((Object)this)).notifyAll();
                }
                Runnable task = this.getTerminationTask();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            oldState = this.state;
        }
    }

    public void shutdown() {
        int oldState = this.state;
        while ((oldState & Integer.MIN_VALUE) == 0) {
            if (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE)) {
                oldState = this.state;
                continue;
            }
            Log.log.tracef("Initiating shutdown of %s", (Object)this);
            for (WorkerThread worker : this.readWorkers) {
                worker.shutdown();
            }
            for (WorkerThread worker : this.writeWorkers) {
                worker.shutdown();
            }
            this.shutDownTaskPool();
            return;
        }
        Log.log.tracef("Idempotent shutdown of %s", (Object)this);
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.shutDownTaskPoolNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        int oldState = this.state;
        if ((oldState & 0x40000000) != 0) {
            return true;
        }
        long start = System.nanoTime();
        long elapsed = 0L;
        NioXnioWorker nioXnioWorker = this;
        synchronized (nioXnioWorker) {
            while (((oldState = this.state) & 0x40000000) == 0) {
                ((Object)((Object)this)).wait(timeout - elapsed);
                elapsed = (System.nanoTime() - start) / 1000000L;
                if (elapsed <= unit.toNanos(timeout)) continue;
                return false;
            }
            return true;
        }
    }

    protected void taskPoolTerminated() {
        this.closeResource();
    }

    public NioXnio getXnio() {
        return (NioXnio)super.getXnio();
    }
}

