/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.WorkerThread;

class NioTcpServerHandle
extends NioHandle {
    private final Runnable freeTask;
    private final NioTcpServer server;
    private int count;
    private int low;
    private int high;
    private boolean stopped;

    NioTcpServerHandle(NioTcpServer server, SelectionKey key, WorkerThread thread, int low, int high) {
        super(thread, key);
        this.server = server;
        this.low = low;
        this.high = high;
        this.freeTask = new Runnable(){

            @Override
            public void run() {
                NioTcpServerHandle.this.freeConnection();
            }
        };
    }

    @Override
    void handleReady(int ops) {
        ChannelListeners.invokeChannelListener((Channel)((Object)this.server), this.server.getAcceptListener());
    }

    @Override
    void forceTermination() {
        IoUtils.safeClose((Closeable)((Object)this.server));
    }

    @Override
    void terminated() {
        this.server.invokeCloseHandler();
    }

    Runnable getFreeTask() {
        return this.freeTask;
    }

    void resume() {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            if (!this.stopped && this.server.resumed) {
                super.resume(16);
            }
        } else {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    NioTcpServerHandle.this.resume();
                }
            });
        }
    }

    void suspend() {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            if (!this.stopped && !this.server.resumed) {
                super.suspend(16);
            }
        } else {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    NioTcpServerHandle.this.suspend();
                }
            });
        }
    }

    void channelClosed() {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            this.freeConnection();
        } else {
            thread.execute(this.freeTask);
        }
    }

    void freeConnection() {
        if (this.count-- <= this.low && this.stopped) {
            this.stopped = false;
            if (this.server.resumed) {
                super.resume(16);
            }
        }
    }

    boolean getConnection() {
        if (this.stopped) {
            return false;
        }
        if (++this.count >= this.high) {
            this.stopped = true;
            super.suspend(16);
        }
        return true;
    }

    public void executeSetTask(final int high, final int low) {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            this.high = high;
            this.low = low;
            if (this.count >= high && !this.stopped) {
                this.stopped = true;
                this.suspend();
            } else if (this.count <= low && this.stopped) {
                this.stopped = false;
                if (this.server.resumed) {
                    this.resume();
                }
            }
        } else {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    NioTcpServerHandle.this.executeSetTask(high, low);
                }
            });
        }
    }
}

