/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Version;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.nio.NioXnioWorker;

final class NioXnio
extends Xnio {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio");
    final SelectorCreator tempSelectorCreator;
    final SelectorCreator mainSelectorCreator;
    private final ThreadLocal<Selector> selectorThreadLocal = new ThreadLocal<Selector>(){

        @Override
        public void remove() {
            IoUtils.safeClose((Selector)((Selector)this.get()));
            super.remove();
        }
    };

    NioXnio() {
        super("nio");
        Object[] objects = AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

            @Override
            public Object[] run() {
                ConstructorSelectorCreator creator;
                SelectorProvider defaultProvider = SelectorProvider.provider();
                String chosenProvider = System.getProperty("xnio.nio.selector.provider");
                SelectorProvider provider = null;
                if (chosenProvider != null) {
                    try {
                        provider = Class.forName(chosenProvider, true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.KQueueSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.EPollSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.DevPollSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.PollsetSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (provider == null) {
                    provider = defaultProvider;
                }
                log.tracef("Starting up with selector provider %s", (Object)provider.getClass().getCanonicalName());
                boolean defaultIsPoll = "sun.nio.ch.PollSelectorProvider".equals(provider.getClass().getName());
                String chosenMainSelector = System.getProperty("xnio.nio.selector.main");
                String chosenTempSelector = System.getProperty("xnio.nio.selector.temp");
                DefaultSelectorCreator defaultSelectorCreator = new DefaultSelectorCreator(provider);
                Object[] objects = new Object[3];
                objects[0] = provider;
                if (chosenTempSelector != null) {
                    try {
                        creator = new ConstructorSelectorCreator(chosenTempSelector, provider);
                        IoUtils.safeClose((Selector)creator.open());
                        objects[1] = creator;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (chosenMainSelector != null) {
                    try {
                        creator = new ConstructorSelectorCreator(chosenMainSelector, provider);
                        IoUtils.safeClose((Selector)creator.open());
                        objects[2] = creator;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!defaultIsPoll && objects[1] == null) {
                    try {
                        creator = new ConstructorSelectorCreator("sun.nio.ch.PollSelectorImpl", provider);
                        IoUtils.safeClose((Selector)creator.open());
                        objects[1] = creator;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (objects[1] == null) {
                    objects[1] = defaultSelectorCreator;
                }
                if (objects[2] == null) {
                    objects[2] = defaultSelectorCreator;
                }
                return objects;
            }
        });
        this.tempSelectorCreator = (SelectorCreator)objects[1];
        this.mainSelectorCreator = (SelectorCreator)objects[2];
        log.tracef("Using %s for main selectors", (Object)this.mainSelectorCreator);
        log.tracef("Using %s for temp selectors", (Object)this.tempSelectorCreator);
    }

    public XnioWorker createWorker(ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException, IllegalArgumentException {
        NioXnioWorker worker = new NioXnioWorker(this, threadGroup, optionMap, terminationTask);
        worker.start();
        return worker;
    }

    Selector getSelector() throws IOException {
        ThreadLocal<Selector> threadLocal = this.selectorThreadLocal;
        Selector selector = threadLocal.get();
        if (selector == null) {
            selector = this.tempSelectorCreator.open();
            threadLocal.set(selector);
        }
        return selector;
    }

    static {
        log.info((Object)("XNIO NIO Implementation Version " + Version.VERSION));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String bugLevel = System.getProperty("sun.nio.ch.bugLevel");
                if (bugLevel == null) {
                    System.setProperty("sun.nio.ch.bugLevel", "");
                }
                return null;
            }
        });
    }

    private static class ConstructorSelectorCreator
    implements SelectorCreator {
        private final Constructor<? extends Selector> constructor;
        private final SelectorProvider provider;

        public ConstructorSelectorCreator(String name, SelectorProvider provider) throws ClassNotFoundException, NoSuchMethodException {
            this.provider = provider;
            Class<Selector> selectorImplClass = Class.forName(name, true, null).asSubclass(Selector.class);
            Constructor<Selector> constructor = selectorImplClass.getDeclaredConstructor(SelectorProvider.class);
            constructor.setAccessible(true);
            this.constructor = constructor;
        }

        @Override
        public Selector open() throws IOException {
            try {
                return this.constructor.newInstance(this.provider);
            }
            catch (InstantiationException e) {
                return Selector.open();
            }
            catch (IllegalAccessException e) {
                return Selector.open();
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getTargetException();
                }
                catch (IOException e2) {
                    throw e2;
                }
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Error e2) {
                    throw e2;
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unexpected invocation exception", t);
                }
            }
        }

        public String toString() {
            return String.format("Selector creator %s for provider %s", this.constructor.getDeclaringClass(), this.provider.getClass());
        }
    }

    private static class DefaultSelectorCreator
    implements SelectorCreator {
        private final SelectorProvider provider;

        private DefaultSelectorCreator(SelectorProvider provider) {
            this.provider = provider;
        }

        @Override
        public Selector open() throws IOException {
            return this.provider.openSelector();
        }

        public String toString() {
            return "Default system selector creator for provider " + this.provider.getClass();
        }
    }

    static interface SelectorCreator {
        public Selector open() throws IOException;
    }
}

