/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.correlation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.core.correlation.CorrelationProperties;

public class Correlation
implements Serializable {
    private static final long serialVersionUID = 4214786559199084264L;
    private String id;
    private String name;
    private Map<String, CorrelationProperties> correlationPropertiesByMessage;
    private CorrelationProperties processCorrelationProperties;

    public Correlation(String id, String name) {
        this.id = id;
        this.name = name;
        this.correlationPropertiesByMessage = new HashMap<String, CorrelationProperties>();
    }

    public CorrelationProperties getMessageCorrelationFor(String messageRef) {
        return this.correlationPropertiesByMessage.computeIfAbsent(messageRef, ref -> new CorrelationProperties());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void subscribe() {
        if (this.isSubscribed()) {
            return;
        }
        this.processCorrelationProperties = new CorrelationProperties();
    }

    public boolean isSubscribed() {
        return this.processCorrelationProperties != null;
    }

    public CorrelationProperties getProcessSubscription() {
        return this.processCorrelationProperties;
    }

    public boolean hasCorrelationFor(String messageRef) {
        return this.correlationPropertiesByMessage.containsKey(messageRef);
    }
}

