/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.domain.internal;

import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.atmos.domain.MutableContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public class DelegatingMutableContentMetadata
implements MutableContentMetadata {
    private URI uri;
    private String name;
    private String path;
    private final org.jclouds.io.MutableContentMetadata delegate;

    public DelegatingMutableContentMetadata() {
        this(null, null, null, (org.jclouds.io.MutableContentMetadata)new BaseMutableContentMetadata());
    }

    public DelegatingMutableContentMetadata(URI uri, String name, String path, org.jclouds.io.MutableContentMetadata delegate) {
        this.uri = uri;
        this.name = name;
        this.delegate = delegate;
        this.path = path;
    }

    public Long getContentLength() {
        return this.delegate.getContentLength();
    }

    public byte[] getContentMD5() {
        return this.delegate.getContentMD5();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setContentLength(Long contentLength) {
        this.delegate.setContentLength(contentLength);
    }

    public void setContentMD5(byte[] contentMD5) {
        this.delegate.setContentMD5(contentMD5);
    }

    public void setContentType(String contentType) {
        this.delegate.setContentType(contentType);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelegatingMutableContentMetadata other = (DelegatingMutableContentMetadata)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public String toString() {
        return "[uri=" + this.uri + ", name=" + this.name + ", path=" + this.path + ", delegate=" + this.delegate + "]";
    }

    public org.jclouds.io.MutableContentMetadata getDelegate() {
        return this.delegate;
    }

    public void setContentDisposition(String contentDisposition) {
        this.delegate.setContentDisposition(contentDisposition);
    }

    public void setContentEncoding(String contentEncoding) {
        this.delegate.setContentEncoding(contentEncoding);
    }

    public void setContentLanguage(String contentLanguage) {
        this.delegate.setContentLanguage(contentLanguage);
    }

    public String getContentDisposition() {
        return this.delegate.getContentDisposition();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public String getContentLanguage() {
        return this.delegate.getContentLanguage();
    }

    public void setPropertiesFromHttpHeaders(Multimap<String, String> headers) {
        this.delegate.setPropertiesFromHttpHeaders(headers);
    }

    public ContentMetadataBuilder toBuilder() {
        return this.delegate.toBuilder();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }
}

