/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.filters;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.Uris;
import org.jclouds.io.InputSuppliers;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public class ShareUrl
implements Function<String, URI> {
    private final Supplier<Credentials> creds;
    private final Supplier<URI> provider;
    private final javax.inject.Provider<Long> timeStampProvider;
    private final Crypto crypto;
    @Resource
    Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public ShareUrl(@Provider Supplier<Credentials> creds, @Provider Supplier<URI> provider, @TimeStamp javax.inject.Provider<Long> timeStampProvider, Crypto crypto) {
        this.creds = creds;
        this.provider = provider;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
    }

    public URI apply(String path) throws HttpException {
        String requestedResource = "/rest/namespace/" + path;
        String expires = ((Long)this.timeStampProvider.get()).toString();
        String signature = this.signString(this.createStringToSign(requestedResource, expires));
        return Uris.uriBuilder((URI)((URI)this.provider.get())).replaceQuery((Map)ImmutableMap.of((Object)"uid", (Object)((Credentials)this.creds.get()).identity, (Object)"expires", (Object)expires, (Object)"signature", (Object)signature)).appendPath(requestedResource).build();
    }

    public String createStringToSign(String requestedResource, String expires) {
        StringBuilder toSign = new StringBuilder();
        toSign.append("GET\n");
        toSign.append(requestedResource.toLowerCase()).append("\n");
        toSign.append(((Credentials)this.creds.get()).identity).append("\n");
        toSign.append(expires);
        return toSign.toString();
    }

    public String signString(String toSign) {
        try {
            return CryptoStreams.base64((byte[])CryptoStreams.mac((InputSupplier)InputSuppliers.of((String)toSign), (Mac)this.crypto.hmacSHA1(((Credentials)this.creds.get()).credential.getBytes())));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

