/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.InputSupplier;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.InputSuppliers;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class SignRequest
implements HttpRequestFilter {
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final javax.inject.Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SignRequest(SignatureWire signatureWire, @Provider Supplier<Credentials> creds, @TimeStamp javax.inject.Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.creds = creds;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
        this.utils = utils;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"x-emc-uid", (Object)((Credentials)this.creds.get()).identity);
        String date = (String)this.timeStampProvider.get();
        builder.put((Object)"Date", (Object)date);
        if (request.getHeaders().containsKey((Object)"x-emc-date")) {
            builder.put((Object)"x-emc-date", (Object)date);
        }
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)Multimaps.forMap((Map)builder.build()))).build();
        String signature = this.calculateSignature(this.createStringToSign(request));
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-emc-signature", new String[]{signature})).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, buffer);
        this.appendCanonicalizedResource(request, buffer);
        this.appendCanonicalizedHeaders(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output((Object)buffer.toString());
        }
        return buffer.toString();
    }

    private String calculateSignature(String toSign) {
        String signature = this.signString(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream((String)signature));
        }
        return signature;
    }

    public String signString(String toSign) {
        String signature;
        try {
            signature = CryptoStreams.base64((byte[])CryptoStreams.mac((InputSupplier)InputSuppliers.of((String)toSign), (Mac)this.crypto.hmacSHA1(CryptoStreams.base64((String)((Credentials)this.creds.get()).credential))));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
        return signature;
    }

    private void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    private void appendCanonicalizedHeaders(HttpRequest request, StringBuilder toSign) {
        TreeSet headers = new TreeSet(request.getHeaders().keySet());
        for (String header : headers) {
            if (!header.startsWith("x-emc-") || header.equals("x-emc-signature")) continue;
            toSign.append(header.toLowerCase()).append(":");
            for (String value : request.getHeaders().get((Object)header)) {
                value = Strings2.replaceAll((String)value, (Pattern)Patterns.TWO_SPACE_PATTERN, (String)" ");
                value = Strings2.replaceAll((String)value, (Pattern)Patterns.NEWLINE_PATTERN, (String)"");
                toSign.append(value).append(' ');
            }
            toSign.deleteCharAt(toSign.lastIndexOf(" "));
            toSign.append("\n");
        }
        if (toSign.charAt(toSign.length() - 1) == '\n') {
            toSign.deleteCharAt(toSign.length() - 1);
        }
    }

    private void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(Strings.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentType())).append("\n");
    }

    @VisibleForTesting
    void appendHttpHeaders(HttpRequest request, StringBuilder toSign) {
        for (String header : new String[]{"Range"}) {
            toSign.append(HttpUtils.nullToEmpty((Collection)request.getHeaders().get((Object)header)).toLowerCase()).append("\n");
        }
        toSign.append(request.getFirstHeaderOrNull("Date")).append("\n");
    }

    @VisibleForTesting
    void appendCanonicalizedResource(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath().toLowerCase()).append("\n");
    }
}

