/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.blobstore.functions.ReturnNullOnContainerNotFound;
import org.jclouds.cloudfiles.CDNManagement;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.cloudfiles.functions.ParseCdnUriFromHeaders;
import org.jclouds.cloudfiles.functions.ParseContainerCDNMetadataFromHeaders;
import org.jclouds.cloudfiles.options.ListCdnContainerOptions;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;

@SkipEncoding(value={47})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Storage.class)
public interface CloudFilesAsyncClient
extends CommonSwiftAsyncClient {
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/")
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<? extends Set<ContainerCDNMetadata>> listCDNContainers(ListCdnContainerOptions ... var1);

    @HEAD
    @ResponseParser(value=ParseContainerCDNMetadataFromHeaders.class)
    @ExceptionParser(value=ReturnNullOnContainerNotFound.class)
    @Path(value="/{container}")
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<ContainerCDNMetadata> getCDNMetadata(@PathParam(value="container") String var1);

    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-CDN-Enabled"}, values={"True"})
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> enableCDN(@PathParam(value="container") String var1, @HeaderParam(value="X-TTL") long var2);

    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-CDN-Enabled"}, values={"True"})
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> enableCDN(@PathParam(value="container") String var1);

    @POST
    @Path(value="/{container}")
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> updateCDN(@PathParam(value="container") String var1, @HeaderParam(value="X-TTL") long var2);

    @POST
    @Path(value="/{container}")
    @Headers(keys={"X-CDN-Enabled"}, values={"False"})
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<Boolean> disableCDN(@PathParam(value="container") String var1);
}

