/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.openstack.swift.domain.ObjectInfo;

@Singleton
public class PublicUriForObjectInfo
implements Function<ObjectInfo, URI> {
    private final LoadingCache<String, URI> cdnContainer;
    private final Provider<UriBuilder> uriBuilders;

    @Inject
    public PublicUriForObjectInfo(LoadingCache<String, URI> cdnContainer, Provider<UriBuilder> uriBuilders) {
        this.cdnContainer = cdnContainer;
        this.uriBuilders = uriBuilders;
    }

    public URI apply(ObjectInfo from) {
        if (from == null) {
            return null;
        }
        try {
            return ((UriBuilder)this.uriBuilders.get()).uri((URI)this.cdnContainer.getUnchecked((Object)from.getContainer())).path(from.getName()).replaceQuery("").build(new Object[0]);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }
}

