/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersAsyncClient;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToImage;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToOperatingSystem;
import org.jclouds.cloudservers.compute.functions.FlavorToHardware;
import org.jclouds.cloudservers.compute.functions.ServerToNodeMetadata;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.RestContextImpl;

public class CloudServersComputeServiceDependenciesModule
extends AbstractModule {
    @VisibleForTesting
    public static final Map<ServerStatus, NodeState> serverToNodeState = ImmutableMap.builder().put((Object)ServerStatus.ACTIVE, (Object)NodeState.RUNNING).put((Object)ServerStatus.SUSPENDED, (Object)NodeState.SUSPENDED).put((Object)ServerStatus.DELETED, (Object)NodeState.TERMINATED).put((Object)ServerStatus.QUEUE_RESIZE, (Object)NodeState.PENDING).put((Object)ServerStatus.PREP_RESIZE, (Object)NodeState.PENDING).put((Object)ServerStatus.RESIZE, (Object)NodeState.PENDING).put((Object)ServerStatus.VERIFY_RESIZE, (Object)NodeState.PENDING).put((Object)ServerStatus.QUEUE_MOVE, (Object)NodeState.PENDING).put((Object)ServerStatus.PREP_MOVE, (Object)NodeState.PENDING).put((Object)ServerStatus.MOVE, (Object)NodeState.PENDING).put((Object)ServerStatus.VERIFY_MOVE, (Object)NodeState.PENDING).put((Object)ServerStatus.RESCUE, (Object)NodeState.PENDING).put((Object)ServerStatus.ERROR, (Object)NodeState.ERROR).put((Object)ServerStatus.BUILD, (Object)NodeState.PENDING).put((Object)ServerStatus.RESTORING, (Object)NodeState.PENDING).put((Object)ServerStatus.PASSWORD, (Object)NodeState.PENDING).put((Object)ServerStatus.REBUILD, (Object)NodeState.PENDING).put((Object)ServerStatus.DELETE_IP, (Object)NodeState.PENDING).put((Object)ServerStatus.SHARE_IP_NO_CONFIG, (Object)NodeState.PENDING).put((Object)ServerStatus.SHARE_IP, (Object)NodeState.PENDING).put((Object)ServerStatus.REBOOT, (Object)NodeState.PENDING).put((Object)ServerStatus.HARD_REBOOT, (Object)NodeState.PENDING).put((Object)ServerStatus.UNKNOWN, (Object)NodeState.UNRECOGNIZED).put((Object)ServerStatus.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).build();

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(CloudServersImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, OperatingSystem>>(){}).to(CloudServersImageToOperatingSystem.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Flavor, Hardware>>(){}).to(FlavorToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral)new TypeLiteral<ComputeServiceContextImpl<CloudServersClient, CloudServersAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<RestContext<CloudServersClient, CloudServersAsyncClient>>(){}).to((TypeLiteral)new TypeLiteral<RestContextImpl<CloudServersClient, CloudServersAsyncClient>>(){}).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    Map<ServerStatus, NodeState> provideServerToNodeState() {
        return serverToNodeState;
    }
}

