/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.strategy;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.RebootType;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;

@Singleton
public class CloudServersLifeCycleStrategy
implements RebootNodeStrategy,
SuspendNodeStrategy,
ResumeNodeStrategy {
    private final CloudServersClient client;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected CloudServersLifeCycleStrategy(CloudServersClient client, GetNodeMetadataStrategy getNode) {
        this.client = client;
        this.getNode = getNode;
    }

    public NodeMetadata rebootNode(String id) {
        int serverId = Integer.parseInt(id);
        this.client.rebootServer(serverId, RebootType.HARD);
        return this.getNode.getNode(id);
    }

    public NodeMetadata suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }

    public NodeMetadata resumeNode(String id) {
        throw new UnsupportedOperationException("resume not supported");
    }
}

