/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.logging.Logger;

@Singleton
public class CloudServersHardwareSupplier
implements Supplier<Set<? extends Hardware>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudServersClient sync;
    private final Function<Flavor, Hardware> flavorToHardware;

    @Inject
    CloudServersHardwareSupplier(CloudServersClient sync, Function<Flavor, Hardware> flavorToHardware) {
        this.sync = sync;
        this.flavorToHardware = flavorToHardware;
    }

    public Set<? extends Hardware> get() {
        this.logger.debug(">> providing hardware", new Object[0]);
        LinkedHashSet hardware = Sets.newLinkedHashSet((Iterable)Iterables.transform(this.sync.listFlavors(ListOptions.Builder.withDetails()), this.flavorToHardware));
        this.logger.debug("<< hardware(%d)", new Object[]{hardware.size()});
        return hardware;
    }
}

