/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class RebuildServerOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    Integer imageId;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap image = Maps.newHashMap();
        if (this.imageId != null) {
            image.put("imageId", this.imageId);
        }
        return (R)this.jsonBinder.bindToRequest(request, (Object)ImmutableMap.of((Object)"rebuild", (Object)image));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("RebuildServer is a POST operation");
    }

    public RebuildServerOptions withImage(int id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"server id must be a positive number");
        this.imageId = id;
        return this;
    }

    public static class Builder {
        public static RebuildServerOptions withImage(int id) {
            RebuildServerOptions options = new RebuildServerOptions();
            return options.withImage(id);
        }
    }
}

