/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateSharedIpGroupOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    Integer serverId;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        SharedIpGroupRequest createRequest = new SharedIpGroupRequest(Preconditions.checkNotNull((Object)postParams.get("name")).toString(), this.serverId);
        return (R)this.jsonBinder.bindToRequest(request, (Object)ImmutableMap.of((Object)"sharedIpGroup", (Object)createRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("CreateSharedIpGroup is a POST operation");
    }

    public CreateSharedIpGroupOptions withServer(int id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"server id must be a positive number");
        this.serverId = id;
        return this;
    }

    public static class Builder {
        public static CreateSharedIpGroupOptions withServer(int id) {
            CreateSharedIpGroupOptions options = new CreateSharedIpGroupOptions();
            return options.withServer(id);
        }
    }

    private static class SharedIpGroupRequest {
        final String name;
        Integer server;

        private SharedIpGroupRequest(String name, @Nullable Integer serverId) {
            this.name = name;
            this.server = serverId;
        }
    }
}

