/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.Drive;

@Singleton
public class BaseDriveToMap
implements Function<Drive, Map<String, String>> {
    public Map<String, String> apply(Drive from) {
        Preconditions.checkNotNull((Object)from, (Object)"drive");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)from.getName());
        builder.put((Object)"size", (Object)(from.getSize() + ""));
        if (from.getClaimType() != ClaimType.EXCLUSIVE) {
            builder.put((Object)"claim:type", (Object)from.getClaimType().toString());
        }
        if (from.getReaders().size() != 0) {
            builder.put((Object)"readers", (Object)Joiner.on((char)' ').join(from.getReaders()));
        }
        if (from.getUse().size() != 0) {
            builder.put((Object)"use", (Object)Joiner.on((char)' ').join(from.getUse()));
        }
        return builder.build();
    }
}

