/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.CloudSigmaAsyncClient;
import org.jclouds.cloudsigma.CloudSigmaClient;
import org.jclouds.cloudsigma.compute.CloudSigmaComputeServiceAdapter;
import org.jclouds.cloudsigma.compute.CloudSigmaTemplateBuilderImpl;
import org.jclouds.cloudsigma.compute.functions.ParseOsFamilyVersion64BitFromImageName;
import org.jclouds.cloudsigma.compute.functions.PreinstalledDiskToImage;
import org.jclouds.cloudsigma.compute.functions.ServerInfoToNodeMetadata;
import org.jclouds.cloudsigma.compute.options.CloudSigmaTemplateOptions;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.cloudsigma.predicates.DriveClaimed;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.location.suppliers.OnlyLocationOrFirstZone;
import org.jclouds.predicates.RetryablePredicate;

public class CloudSigmaComputeServiceContextModule
extends ComputeServiceAdapterContextModule<CloudSigmaClient, CloudSigmaAsyncClient, ServerInfo, Hardware, DriveInfo, Location> {
    public CloudSigmaComputeServiceContextModule() {
        super(CloudSigmaClient.class, CloudSigmaAsyncClient.class);
    }

    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.UBUNTU).imageNameMatches(".*automated SSH Access.*");
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<ServerInfo, Hardware, DriveInfo, Location>>(){}).to(CloudSigmaComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServerInfo, NodeMetadata>>(){}).to(ServerInfoToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Hardware, Hardware>>(){}).to(IdentityFunction.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<DriveInfo, Image>>(){}).to(PreinstalledDiskToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to(IdentityFunction.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Device, Volume>>(){}).to(ServerInfoToNodeMetadata.DeviceToVolume.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, String>>(){}).to(ServerInfoToNodeMetadata.GetImageIdFromServer.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<String, Image>>(){}).to(ServerInfoToNodeMetadata.FindImageForId.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<String, OsFamilyVersion64Bit>>(){}).to(ParseOsFamilyVersion64BitFromImageName.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Location>>(){}).to(OnlyLocationOrFirstZone.class);
        this.bind(TemplateBuilder.class).to(CloudSigmaTemplateBuilderImpl.class);
    }

    @Provides
    @Singleton
    protected LoadingCache<String, DriveInfo> cache(GetDrive getDrive) {
        return CacheBuilder.newBuilder().build((CacheLoader)getDrive);
    }

    @Provides
    @Singleton
    protected Predicate<DriveInfo> supplyDriveUnclaimed(DriveClaimed driveClaimed, ComputeServiceConstants.Timeouts timeouts) {
        return new RetryablePredicate(Predicates.not((Predicate)driveClaimed), timeouts.nodeRunning, 1000L, TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    protected TemplateOptions templateOptions() {
        return new CloudSigmaTemplateOptions();
    }

    @Singleton
    public static class GetDrive
    extends CacheLoader<String, DriveInfo> {
        private final CloudSigmaClient client;

        @Inject
        public GetDrive(CloudSigmaClient client) {
            this.client = client;
        }

        public DriveInfo load(String input) {
            return this.client.getDriveInfo(input);
        }
    }
}

