/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

public class DriveMetrics {
    protected final long readBytes;
    protected final long readRequests;
    protected final long writeBytes;
    protected final long writeRequests;

    public DriveMetrics(long readBytes, long readRequests, long writeBytes, long writeRequests) {
        this.readBytes = readBytes;
        this.readRequests = readRequests;
        this.writeBytes = writeBytes;
        this.writeRequests = writeRequests;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getReadRequests() {
        return this.readRequests;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public long getWriteRequests() {
        return this.writeRequests;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.readBytes ^ this.readBytes >>> 32);
        result = 31 * result + (int)(this.readRequests ^ this.readRequests >>> 32);
        result = 31 * result + (int)(this.writeBytes ^ this.writeBytes >>> 32);
        result = 31 * result + (int)(this.writeRequests ^ this.writeRequests >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DriveMetrics other = (DriveMetrics)obj;
        if (this.readBytes != other.readBytes) {
            return false;
        }
        if (this.readRequests != other.readRequests) {
            return false;
        }
        if (this.writeBytes != other.writeBytes) {
            return false;
        }
        return this.writeRequests == other.writeRequests;
    }

    public String toString() {
        return "[readBytes=" + this.readBytes + ", readRequests=" + this.readRequests + ", writeBytes=" + this.writeBytes + ", writeRequests=" + this.writeRequests + "]";
    }

    public static class Builder {
        protected long readBytes;
        protected long readRequests;
        protected long writeBytes;
        protected long writeRequests;

        public Builder readBytes(long readBytes) {
            this.readBytes = readBytes;
            return this;
        }

        public Builder readRequests(long readRequests) {
            this.readRequests = readRequests;
            return this;
        }

        public Builder writeBytes(long writeBytes) {
            this.writeBytes = writeBytes;
            return this;
        }

        public Builder writeRequests(long writeRequests) {
            this.writeRequests = writeRequests;
            return this;
        }

        public DriveMetrics build() {
            return new DriveMetrics(this.readBytes, this.readRequests, this.writeBytes, this.writeRequests);
        }
    }
}

