/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.IDEDevice;
import org.jclouds.cloudsigma.domain.Model;
import org.jclouds.cloudsigma.domain.NIC;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.VNC;

public class Servers {
    public static Server.Builder small(String name, String driveUuuid, String vncPassword) {
        return Servers.smallWithStaticIP(name, driveUuuid, vncPassword, "auto");
    }

    public static Server.Builder smallWithStaticIP(String name, String driveUuuid, String vncPassword, String ip) {
        return new Server.Builder().name(name).cpu(1000).mem(512).persistent(true).devices((Map<String, ? extends Device>)ImmutableMap.of((Object)"ide:0:0", (Object)new IDEDevice.Builder(0, 0).uuid(driveUuuid).build())).bootDeviceIds((Iterable<String>)ImmutableSet.of((Object)"ide:0:0")).nics((Iterable<NIC>)ImmutableSet.of((Object)new NIC.Builder().model(Model.E1000).dhcp(ip).build())).vnc(new VNC(null, vncPassword, false));
    }

    public static Server changeIP(Server in, String ip) {
        return Server.Builder.fromServer(in).nics((Iterable<NIC>)ImmutableSet.of((Object)new NIC.Builder().model(Model.E1000).dhcp(ip).build())).build();
    }
}

