/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindTemplateMetadataToQueryParams
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindTemplateMetadataToQueryParams(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = (Provider)Preconditions.checkNotNull(uriBuilderProvider, (Object)"uriBuilderProvider");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof TemplateMetadata), (Object)"this binder is only valid for TemplateMetadata");
        TemplateMetadata metadata = (TemplateMetadata)input;
        request = ModifyRequest.addQueryParam(request, (String)"name", (Object)metadata.getName(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        request = ModifyRequest.addQueryParam(request, (String)"ostypeid", (Object)metadata.getOsTypeId(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        request = ModifyRequest.addQueryParam(request, (String)"displaytext", (Object)metadata.getDisplayText(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        if (metadata.getSnapshotId() != null) {
            request = ModifyRequest.addQueryParam(request, (String)"snapshotid", (Object)metadata.getSnapshotId(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        }
        if (metadata.getVolumeId() != null) {
            request = ModifyRequest.addQueryParam(request, (String)"volumeid", (Object)metadata.getVolumeId(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        }
        if (metadata.getVirtualMachineId() != null) {
            request = ModifyRequest.addQueryParam(request, (String)"virtualmachineid", (Object)metadata.getVirtualMachineId(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        }
        if (metadata.getPasswordEnabled() != null) {
            request = ModifyRequest.addQueryParam(request, (String)"passwordenabled", (Object)metadata.getPasswordEnabled(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        }
        return request;
    }
}

