/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackAsyncClient;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.compute.functions.ServiceOfferingToHardware;
import org.jclouds.cloudstack.compute.functions.TemplateToImage;
import org.jclouds.cloudstack.compute.functions.TemplateToOperatingSystem;
import org.jclouds.cloudstack.compute.functions.VirtualMachineToNodeMetadata;
import org.jclouds.cloudstack.compute.functions.ZoneToLocation;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.AdvancedNetworkOptionsConverter;
import org.jclouds.cloudstack.compute.strategy.BasicNetworkOptionsConverter;
import org.jclouds.cloudstack.compute.strategy.CloudStackComputeServiceAdapter;
import org.jclouds.cloudstack.compute.strategy.OptionsConverter;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.GuestOSClient;
import org.jclouds.cloudstack.functions.StaticNATVirtualMachineInNetwork;
import org.jclouds.cloudstack.functions.ZoneIdToZone;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.cloudstack.predicates.JobComplete;
import org.jclouds.cloudstack.suppliers.GetCurrentUser;
import org.jclouds.cloudstack.suppliers.NetworksForCurrentUser;
import org.jclouds.cloudstack.suppliers.ZoneIdToZoneSupplier;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.location.suppliers.OnlyLocationOrFirstZone;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

public class CloudStackComputeServiceContextModule
extends ComputeServiceAdapterContextModule<CloudStackClient, CloudStackAsyncClient, VirtualMachine, ServiceOffering, Template, Zone> {
    public CloudStackComputeServiceContextModule() {
        super(CloudStackClient.class, CloudStackAsyncClient.class);
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VirtualMachine, ServiceOffering, Template, Zone>>(){}).to(CloudStackComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualMachine, NodeMetadata>>(){}).to(VirtualMachineToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Template, Image>>(){}).to(TemplateToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServiceOffering, Hardware>>(){}).to(ServiceOfferingToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Zone, Location>>(){}).to(ZoneToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Location>>(){}).to(OnlyLocationOrFirstZone.class);
        this.bind(TemplateOptions.class).to(CloudStackTemplateOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Template, OperatingSystem>>(){}).to(TemplateToOperatingSystem.class);
        this.install(new FactoryModuleBuilder().build(StaticNATVirtualMachineInNetwork.Factory.class));
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<Long, Set<IPForwardingRule>>>(){}).to(GetIPForwardingRulesByVirtualMachine.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<Long, Zone>>(){}).to(ZoneIdToZone.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<Long, Zone>>>(){}).to(ZoneIdToZoneSupplier.class);
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<Long, String>> listOSCategories(@Named(value="jclouds.session-interval") long seconds, final CloudStackClient client) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Map<Long, String>>(){

            public Map<Long, String> get() {
                GuestOSClient guestOSClient = client.getGuestOSClient();
                return guestOSClient.listOSCategories();
            }
        });
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<Long, OSType>> listOSTypes(@Named(value="jclouds.session-interval") long seconds, final CloudStackClient client) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Map<Long, OSType>>(){

            public Map<Long, OSType> get() {
                GuestOSClient guestOSClient = client.getGuestOSClient();
                return Maps.uniqueIndex(guestOSClient.listOSTypes(new ListOSTypesOptions[0]), (Function)new Function<OSType, Long>(){

                    public Long apply(OSType arg0) {
                        return arg0.getId();
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<Long, Network>> listNetworks(@Named(value="jclouds.session-interval") long seconds, NetworksForCurrentUser networksForCurrentUser) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)networksForCurrentUser);
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<User> getCurrentUser(@Named(value="jclouds.session-interval") long seconds, GetCurrentUser getCurrentUser) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)getCurrentUser);
    }

    @Provides
    @Singleton
    protected Predicate<Long> jobComplete(JobComplete jobComplete) {
        return new RetryablePredicate((Predicate)jobComplete, 1200L, 1L, 5L, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine(CacheLoader<Long, Set<IPForwardingRule>> getIPForwardingRules) {
        return CacheBuilder.newBuilder().build(getIPForwardingRules);
    }

    @Provides
    @Singleton
    Map<NetworkType, ? extends OptionsConverter> optionsConverters() {
        return ImmutableMap.of((Object)((Object)NetworkType.ADVANCED), (Object)new AdvancedNetworkOptionsConverter(), (Object)((Object)NetworkType.BASIC), (Object)new BasicNetworkOptionsConverter());
    }

    @Singleton
    public static class GetIPForwardingRulesByVirtualMachine
    extends CacheLoader<Long, Set<IPForwardingRule>> {
        private final CloudStackClient client;

        @Inject
        public GetIPForwardingRulesByVirtualMachine(CloudStackClient client) {
            this.client = (CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        }

        public Set<IPForwardingRule> load(Long input) {
            ImmutableSet rules = this.client.getNATClient().getIPForwardingRulesForVirtualMachine(input);
            return rules != null ? rules : ImmutableSet.of();
        }
    }
}

