/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import javax.annotation.Nullable;

public class PublicIPAddress
implements Comparable<PublicIPAddress> {
    private long id;
    private String account;
    private Date allocated;
    @SerializedName(value="associatednetworkid")
    private long associatedNetworkId;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="forvirtualnetwork")
    private boolean usesVirtualNetwork;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="issourcenat")
    private boolean isSourceNAT;
    @SerializedName(value="isstaticnat")
    private boolean isStaticNAT;
    @SerializedName(value="networkid")
    private long networkId;
    private State state;
    @SerializedName(value="virtualmachinedisplayname")
    private String virtualMachineDisplayName;
    @SerializedName(value="virtualmachineid")
    private long virtualMachineId = -1L;
    @SerializedName(value="virtualmachinename")
    private String virtualMachineName;
    @SerializedName(value="VLANid")
    private long VLANId;
    @SerializedName(value="VLANname")
    private String VLANName;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    @SerializedName(value="jobid")
    @Nullable
    private Long jobId;
    @SerializedName(value="jobstatus")
    @Nullable
    private Integer jobStatus;

    public static Builder builder() {
        return new Builder();
    }

    PublicIPAddress() {
    }

    public PublicIPAddress(long id, String account, Date allocated, long associatedNetworkId, String domain, long domainId, boolean usesVirtualNetwork, String iPAddress, boolean isSourceNAT, boolean isStaticNAT, long networkId, State state, String virtualMachineDisplayName, long virtualMachineId, String virtualMachineName, long VLANId, String VLANName, long zoneId, String zoneName, Long jobId, Integer jobStatus) {
        this.id = id;
        this.account = account;
        this.allocated = allocated;
        this.associatedNetworkId = associatedNetworkId;
        this.domain = domain;
        this.domainId = domainId;
        this.usesVirtualNetwork = usesVirtualNetwork;
        this.IPAddress = iPAddress;
        this.isSourceNAT = isSourceNAT;
        this.isStaticNAT = isStaticNAT;
        this.networkId = networkId;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.VLANId = VLANId;
        this.VLANName = VLANName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
    }

    @Override
    public int compareTo(PublicIPAddress arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getAllocated() {
        return this.allocated;
    }

    @Nullable
    public Long getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public long getAssociatedNetworkId() {
        return this.associatedNetworkId;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public boolean usesVirtualNetwork() {
        return this.usesVirtualNetwork;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public boolean isSourceNAT() {
        return this.isSourceNAT;
    }

    public boolean isStaticNAT() {
        return this.isStaticNAT;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public State getState() {
        return this.state;
    }

    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    public long getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public long getVLANId() {
        return this.VLANId;
    }

    public String getVLANName() {
        return this.VLANName;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.IPAddress == null ? 0 : this.IPAddress.hashCode());
        result = 31 * result + (int)(this.VLANId ^ this.VLANId >>> 32);
        result = 31 * result + (this.VLANName == null ? 0 : this.VLANName.hashCode());
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (this.allocated == null ? 0 : this.allocated.hashCode());
        result = 31 * result + (int)(this.associatedNetworkId ^ this.associatedNetworkId >>> 32);
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isSourceNAT ? 1231 : 1237);
        result = 31 * result + (this.isStaticNAT ? 1231 : 1237);
        result = 31 * result + (int)(this.networkId ^ this.networkId >>> 32);
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.usesVirtualNetwork ? 1231 : 1237);
        result = 31 * result + (this.virtualMachineDisplayName == null ? 0 : this.virtualMachineDisplayName.hashCode());
        result = 31 * result + (int)(this.virtualMachineId ^ this.virtualMachineId >>> 32);
        result = 31 * result + (this.virtualMachineName == null ? 0 : this.virtualMachineName.hashCode());
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName == null ? 0 : this.zoneName.hashCode());
        result = 31 * result + (this.jobStatus == null ? 0 : this.jobStatus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicIPAddress other = (PublicIPAddress)obj;
        if (this.IPAddress == null ? other.IPAddress != null : !this.IPAddress.equals(other.IPAddress)) {
            return false;
        }
        if (this.VLANId != other.VLANId) {
            return false;
        }
        if (this.VLANName == null ? other.VLANName != null : !this.VLANName.equals(other.VLANName)) {
            return false;
        }
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.allocated == null ? other.allocated != null : !this.allocated.equals(other.allocated)) {
            return false;
        }
        if (this.associatedNetworkId != other.associatedNetworkId) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isSourceNAT != other.isSourceNAT) {
            return false;
        }
        if (this.isStaticNAT != other.isStaticNAT) {
            return false;
        }
        if (this.networkId != other.networkId) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        if (this.usesVirtualNetwork != other.usesVirtualNetwork) {
            return false;
        }
        if (this.virtualMachineDisplayName == null ? other.virtualMachineDisplayName != null : !this.virtualMachineDisplayName.equals(other.virtualMachineDisplayName)) {
            return false;
        }
        if (this.virtualMachineId != other.virtualMachineId) {
            return false;
        }
        if (this.virtualMachineName == null ? other.virtualMachineName != null : !this.virtualMachineName.equals(other.virtualMachineName)) {
            return false;
        }
        if (this.zoneId != other.zoneId) {
            return false;
        }
        if (this.zoneName == null ? other.zoneName != null : !this.zoneName.equals(other.zoneName)) {
            return false;
        }
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        return !(this.jobStatus == null ? other.jobStatus != null : !this.jobStatus.equals(other.jobStatus));
    }

    public String toString() {
        return "PublicIPAddress{id=" + this.id + ", account='" + this.account + '\'' + ", allocated=" + this.allocated + ", associatedNetworkId=" + this.associatedNetworkId + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", usesVirtualNetwork=" + this.usesVirtualNetwork + ", IPAddress='" + this.IPAddress + '\'' + ", isSourceNAT=" + this.isSourceNAT + ", isStaticNAT=" + this.isStaticNAT + ", networkId=" + this.networkId + ", state=" + (Object)((Object)this.state) + ", virtualMachineDisplayName='" + this.virtualMachineDisplayName + '\'' + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName='" + this.virtualMachineName + '\'' + ", VLANId=" + this.VLANId + ", VLANName='" + this.VLANName + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", jobId=" + this.jobId + ", jobStatus=" + this.jobStatus + '}';
    }

    public static enum State {
        ALLOCATING,
        ALLOCATED,
        RELEASING,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private long id;
        private String account;
        private Date allocated;
        private long associatedNetworkId;
        private String domain;
        private long domainId;
        private boolean usesVirtualNetwork;
        private String IPAddress;
        private boolean isSourceNAT;
        private boolean isStaticNAT;
        private long networkId;
        private State state;
        private String virtualMachineDisplayName;
        private long virtualMachineId = -1L;
        private String virtualMachineName;
        private long VLANId;
        private String VLANName;
        private long zoneId;
        private String zoneName;
        private Long jobId;
        private Integer jobStatus;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder allocated(Date allocated) {
            this.allocated = allocated;
            return this;
        }

        public Builder associatedNetworkId(long associatedNetworkId) {
            this.associatedNetworkId = associatedNetworkId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder usesVirtualNetwork(boolean usesVirtualNetwork) {
            this.usesVirtualNetwork = usesVirtualNetwork;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder isSourceNAT(boolean isSourceNAT) {
            this.isSourceNAT = isSourceNAT;
            return this;
        }

        public Builder isStaticNAT(boolean isStaticNAT) {
            this.isStaticNAT = isStaticNAT;
            return this;
        }

        public Builder networkId(long networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this;
        }

        public Builder virtualMachineId(long virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder VLANId(long VLANId) {
            this.VLANId = VLANId;
            return this;
        }

        public Builder VLANName(String VLANName) {
            this.VLANName = VLANName;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder jobId(Long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(int jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public PublicIPAddress build() {
            return new PublicIPAddress(this.id, this.account, this.allocated, this.associatedNetworkId, this.domain, this.domainId, this.usesVirtualNetwork, this.IPAddress, this.isSourceNAT, this.isStaticNAT, this.networkId, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.VLANId, this.VLANName, this.zoneId, this.zoneName, this.jobId, this.jobStatus);
        }
    }
}

