/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.options.CreateIPForwardingRuleOptions;
import org.jclouds.cloudstack.options.ListIPForwardingRulesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
public interface NATAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listIpForwardingRules"})
    @SelectJson(value="ipforwardingrule")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<IPForwardingRule>> listIPForwardingRules(ListIPForwardingRulesOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"listIpForwardingRules"})
    @SelectJson(value="ipforwardingrule")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<IPForwardingRule> getIPForwardingRule(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"listIpForwardingRules"})
    @SelectJson(value="ipforwardingrule")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Set<IPForwardingRule>> getIPForwardingRulesForIPAddress(@QueryParam(value="ipaddressid") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"listIpForwardingRules"})
    @SelectJson(value="ipforwardingrule")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Set<IPForwardingRule>> getIPForwardingRulesForVirtualMachine(@QueryParam(value="virtualmachineid") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"createIpForwardingRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> createIPForwardingRule(@QueryParam(value="ipaddressid") long var1, @QueryParam(value="protocol") String var3, @QueryParam(value="startport") int var4, CreateIPForwardingRuleOptions ... var5);

    @GET
    @QueryParams(keys={"command"}, values={"enableStaticNat"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Void> enableStaticNATForVirtualMachine(@QueryParam(value="virtualmachineid") long var1, @QueryParam(value="ipaddressid") long var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteIpForwardingRule"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Long> deleteIPForwardingRule(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"disableStaticNat"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Long> disableStaticNATOnPublicIP(@QueryParam(value="ipaddressid") long var1);
}

