/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Capabilities {
    @Named(value="cloudstackversion")
    private final String cloudStackVersion;
    @Named(value="securitygroupsenabled")
    private final boolean securityGroupsEnabled;
    @Named(value="userpublictemplateenabled")
    private final boolean canShareTemplates;
    private final boolean firewallRuleUiEnabled;
    private final boolean supportELB;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCapabilities(this);
    }

    @ConstructorProperties(value={"cloudstackversion", "securitygroupsenabled", "userpublictemplateenabled", "firewallRuleUiEnabled", "supportELB"})
    protected Capabilities(@Nullable String cloudStackVersion, boolean securityGroupsEnabled, boolean canShareTemplates, boolean firewallRuleUiEnabled, boolean supportELB) {
        this.cloudStackVersion = cloudStackVersion;
        this.securityGroupsEnabled = securityGroupsEnabled;
        this.canShareTemplates = canShareTemplates;
        this.firewallRuleUiEnabled = firewallRuleUiEnabled;
        this.supportELB = supportELB;
    }

    @Nullable
    public String getCloudStackVersion() {
        return this.cloudStackVersion;
    }

    public boolean isSecurityGroupsEnabled() {
        return this.securityGroupsEnabled;
    }

    public boolean canShareTemplates() {
        return this.canShareTemplates;
    }

    public boolean isFirewallRuleUiEnabled() {
        return this.firewallRuleUiEnabled;
    }

    public boolean isSupportELB() {
        return this.supportELB;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cloudStackVersion, this.securityGroupsEnabled, this.canShareTemplates, this.firewallRuleUiEnabled, this.supportELB});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Capabilities that = (Capabilities)Capabilities.class.cast(obj);
        return Objects.equal((Object)this.cloudStackVersion, (Object)that.cloudStackVersion) && Objects.equal((Object)this.securityGroupsEnabled, (Object)that.securityGroupsEnabled) && Objects.equal((Object)this.canShareTemplates, (Object)that.canShareTemplates) && Objects.equal((Object)this.firewallRuleUiEnabled, (Object)that.firewallRuleUiEnabled) && Objects.equal((Object)this.supportELB, (Object)that.supportELB);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("cloudStackVersion", (Object)this.cloudStackVersion).add("securityGroupsEnabled", this.securityGroupsEnabled).add("canShareTemplates", this.canShareTemplates).add("firewallRuleUiEnabled", this.firewallRuleUiEnabled).add("supportELB", this.supportELB);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String cloudStackVersion;
        protected boolean securityGroupsEnabled;
        protected boolean canShareTemplates;
        protected boolean firewallRuleUiEnabled;
        protected boolean supportELB;

        protected abstract T self();

        public T cloudStackVersion(String cloudStackVersion) {
            this.cloudStackVersion = cloudStackVersion;
            return this.self();
        }

        public T securityGroupsEnabled(boolean securityGroupsEnabled) {
            this.securityGroupsEnabled = securityGroupsEnabled;
            return this.self();
        }

        public T canShareTemplates(boolean canShareTemplates) {
            this.canShareTemplates = canShareTemplates;
            return this.self();
        }

        public T firewallRuleUiEnabled(boolean firewallRuleUiEnabled) {
            this.firewallRuleUiEnabled = firewallRuleUiEnabled;
            return this.self();
        }

        public T supportELB(boolean supportELB) {
            this.supportELB = supportELB;
            return this.self();
        }

        public Capabilities build() {
            return new Capabilities(this.cloudStackVersion, this.securityGroupsEnabled, this.canShareTemplates, this.firewallRuleUiEnabled, this.supportELB);
        }

        public T fromCapabilities(Capabilities in) {
            return ((Builder)((Builder)((Builder)((Builder)this.cloudStackVersion(in.getCloudStackVersion())).securityGroupsEnabled(in.isSecurityGroupsEnabled())).canShareTemplates(in.canShareTemplates())).firewallRuleUiEnabled(in.isFirewallRuleUiEnabled())).supportELB(in.isSupportELB());
        }
    }
}

