/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class OSType
implements Comparable<OSType> {
    private final String id;
    @Named(value="oscategoryid")
    private final String OSCategoryId;
    private final String description;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromOSType(this);
    }

    @ConstructorProperties(value={"id", "oscategoryid", "description"})
    protected OSType(String id, @Nullable String OSCategoryId, @Nullable String description) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.OSCategoryId = OSCategoryId;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getOSCategoryId() {
        return this.OSCategoryId;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.OSCategoryId, this.description});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OSType that = (OSType)OSType.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.OSCategoryId, (Object)that.OSCategoryId) && Objects.equal((Object)this.description, (Object)that.description);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("OSCategoryId", (Object)this.OSCategoryId).add("description", (Object)this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(OSType o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String OSCategoryId;
        protected String description;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T OSCategoryId(String OSCategoryId) {
            this.OSCategoryId = OSCategoryId;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public OSType build() {
            return new OSType(this.id, this.OSCategoryId, this.description);
        }

        public T fromOSType(OSType in) {
            return ((Builder)((Builder)this.id(in.getId())).OSCategoryId(in.getOSCategoryId())).description(in.getDescription());
        }
    }
}

