/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.javax.annotation.Nullable;

public class SnapshotPolicy {
    private final String id;
    @Named(value="intervaltype")
    private final Snapshot.Interval interval;
    @Named(value="maxsnaps")
    private final long numberToRetain;
    private final String schedule;
    private final String timezone;
    @Named(value="volumeid")
    private final String volumeId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSnapshotPolicy(this);
    }

    @ConstructorProperties(value={"id", "intervaltype", "maxsnaps", "schedule", "timezone", "volumeid"})
    protected SnapshotPolicy(String id, @Nullable Snapshot.Interval interval, long numberToRetain, @Nullable String schedule, @Nullable String timezone, @Nullable String volumeId) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.interval = interval;
        this.numberToRetain = numberToRetain;
        this.schedule = schedule;
        this.timezone = timezone;
        this.volumeId = volumeId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public Snapshot.Interval getInterval() {
        return this.interval;
    }

    public long getNumberToRetain() {
        return this.numberToRetain;
    }

    @Nullable
    public String getSchedule() {
        return this.schedule;
    }

    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    @Nullable
    public String getVolumeId() {
        return this.volumeId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.interval, this.numberToRetain, this.schedule, this.timezone, this.volumeId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotPolicy that = (SnapshotPolicy)SnapshotPolicy.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.interval), (Object)((Object)that.interval)) && Objects.equal((Object)this.numberToRetain, (Object)that.numberToRetain) && Objects.equal((Object)this.schedule, (Object)that.schedule) && Objects.equal((Object)this.timezone, (Object)that.timezone) && Objects.equal((Object)this.volumeId, (Object)that.volumeId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("interval", (Object)this.interval).add("numberToRetain", this.numberToRetain).add("schedule", (Object)this.schedule).add("timezone", (Object)this.timezone).add("volumeId", (Object)this.volumeId);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected Snapshot.Interval interval;
        protected long numberToRetain;
        protected String schedule;
        protected String timezone;
        protected String volumeId;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T interval(Snapshot.Interval interval) {
            this.interval = interval;
            return this.self();
        }

        public T numberToRetain(long numberToRetain) {
            this.numberToRetain = numberToRetain;
            return this.self();
        }

        public T schedule(String schedule) {
            this.schedule = schedule;
            return this.self();
        }

        public T timezone(String timezone) {
            this.timezone = timezone;
            return this.self();
        }

        public T volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this.self();
        }

        public SnapshotPolicy build() {
            return new SnapshotPolicy(this.id, this.interval, this.numberToRetain, this.schedule, this.timezone, this.volumeId);
        }

        public T fromSnapshotPolicy(SnapshotPolicy in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).interval(in.getInterval())).numberToRetain(in.getNumberToRetain())).schedule(in.getSchedule())).timezone(in.getTimezone())).volumeId(in.getVolumeId());
        }
    }
}

