/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.functions.ParseIdToNameEntryFromHttpResponse;
import org.jclouds.cloudstack.functions.ParseIdToNameFromHttpResponse;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GuestOSAsyncClient {
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsTypes", "true"})
    @SelectJson(value="ostype")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<OSType>> listOSTypes(ListOSTypesOptions ... var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsTypes", "true"})
    @SelectJson(value="ostype")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<OSType> getOSType(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsCategories", "true"})
    @ResponseParser(value=ParseIdToNameFromHttpResponse.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Map<String, String>> listOSCategories();

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsCategories", "true"})
    @ResponseParser(value=ParseIdToNameEntryFromHttpResponse.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Map.Entry<String, String>> getOSCategory(@QueryParam(value="id") String var1);
}

