/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.IPForwardingRule;

@Singleton
public class GetIPForwardingRulesByVirtualMachine
extends CacheLoader<String, Set<IPForwardingRule>> {
    private final CloudStackClient client;

    @Inject
    public GetIPForwardingRulesByVirtualMachine(CloudStackClient client) {
        this.client = (CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public Set<IPForwardingRule> load(String input) {
        return this.client.getNATClient().getIPForwardingRulesForVirtualMachine(input);
    }
}

