/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.encryption.internal.Base64;

public class DeployVirtualMachineOptions
extends AccountInDomainOptions {
    public static final DeployVirtualMachineOptions NONE = new DeployVirtualMachineOptions();

    public DeployVirtualMachineOptions diskOfferingId(String diskofferingid) {
        Preconditions.checkArgument((!this.queryParameters.containsKey((Object)"size") ? 1 : 0) != 0, (Object)"Mutually exclusive with size");
        this.queryParameters.replaceValues((Object)"diskofferingid", (Iterable)ImmutableSet.of((Object)(diskofferingid + "")));
        return this;
    }

    public DeployVirtualMachineOptions displayName(String displayName) {
        this.queryParameters.replaceValues((Object)"displayname", (Iterable)ImmutableSet.of((Object)displayName));
        return this;
    }

    public DeployVirtualMachineOptions group(String group) {
        this.queryParameters.replaceValues((Object)"group", (Iterable)ImmutableSet.of((Object)group));
        return this;
    }

    public DeployVirtualMachineOptions hypervisor(String hypervisor) {
        this.queryParameters.replaceValues((Object)"hypervisor", (Iterable)ImmutableSet.of((Object)hypervisor));
        return this;
    }

    public DeployVirtualMachineOptions keyPair(String keyPair) {
        this.queryParameters.replaceValues((Object)"keypair", (Iterable)ImmutableSet.of((Object)keyPair));
        return this;
    }

    public DeployVirtualMachineOptions name(String name) {
        this.queryParameters.replaceValues((Object)"name", (Iterable)ImmutableSet.of((Object)name));
        return this;
    }

    public DeployVirtualMachineOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
        this.queryParameters.replaceValues((Object)"ipaddress", (Iterable)ImmutableSet.of((Object)ipOnDefaultNetwork));
        return this;
    }

    public DeployVirtualMachineOptions ipsToNetworks(Map<String, String> ipsToNetworks) {
        int count = 0;
        for (String ip : ipsToNetworks.keySet()) {
            this.queryParameters.replaceValues((Object)String.format("iptonetworklist[%d].ip", count), (Iterable)ImmutableSet.of((Object)ip));
            this.queryParameters.replaceValues((Object)String.format("iptonetworklist[%d].networkid", count), (Iterable)ImmutableSet.of((Object)("" + ipsToNetworks.get(ip))));
            ++count;
        }
        return this;
    }

    public DeployVirtualMachineOptions networkId(String networkId) {
        this.queryParameters.replaceValues((Object)"networkids", (Iterable)ImmutableSet.of((Object)(networkId + "")));
        return this;
    }

    public DeployVirtualMachineOptions networkIds(Iterable<String> networkIds) {
        this.queryParameters.replaceValues((Object)"networkids", (Iterable)ImmutableSet.of((Object)Joiner.on((char)',').join(networkIds)));
        return this;
    }

    public Iterable<String> getNetworkIds() {
        if (this.queryParameters.get((Object)"networkids").size() == 1) {
            return Iterables.transform((Iterable)Splitter.on((String)",").split((CharSequence)Iterables.getOnlyElement((Iterable)this.queryParameters.get((Object)"networkids"))), (Function)new Function<String, String>(){

                public String apply(String arg0) {
                    return arg0;
                }
            });
        }
        return ImmutableSet.of();
    }

    public DeployVirtualMachineOptions securityGroupId(String securityGroupId) {
        this.queryParameters.replaceValues((Object)"securitygroupids", (Iterable)ImmutableSet.of((Object)(securityGroupId + "")));
        return this;
    }

    public DeployVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
        this.queryParameters.replaceValues((Object)"securitygroupids", (Iterable)ImmutableSet.of((Object)Joiner.on((char)',').join(securityGroupIds)));
        return this;
    }

    public DeployVirtualMachineOptions dataDiskSize(long dataDiskSize) {
        Preconditions.checkArgument((!this.queryParameters.containsKey((Object)"diskofferingid") ? 1 : 0) != 0, (Object)"Mutually exclusive with diskOfferingId");
        this.queryParameters.replaceValues((Object)"size", (Iterable)ImmutableSet.of((Object)(dataDiskSize + "")));
        return this;
    }

    public DeployVirtualMachineOptions userData(byte[] unencodedData) {
        int length = ((byte[])Preconditions.checkNotNull((Object)unencodedData, (Object)"unencodedData")).length;
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"userData cannot be empty");
        Preconditions.checkArgument((length <= 2048 ? 1 : 0) != 0, (Object)"userData cannot be larger than 2kb");
        this.queryParameters.replaceValues((Object)"userdata", (Iterable)ImmutableSet.of((Object)Base64.encodeBytes((byte[])unencodedData)));
        return this;
    }

    @Override
    public DeployVirtualMachineOptions accountInDomain(String account, String domain) {
        return (DeployVirtualMachineOptions)((Object)DeployVirtualMachineOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public DeployVirtualMachineOptions domainId(String domainId) {
        return (DeployVirtualMachineOptions)((Object)DeployVirtualMachineOptions.class.cast((Object)super.domainId(domainId)));
    }

    public static class Builder {
        public static DeployVirtualMachineOptions diskOfferingId(String diskOfferingId) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.diskOfferingId(diskOfferingId);
        }

        public static DeployVirtualMachineOptions displayName(String displayName) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.displayName(displayName);
        }

        public static DeployVirtualMachineOptions group(String group) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.group(group);
        }

        public static DeployVirtualMachineOptions hypervisor(String hypervisor) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.hypervisor(hypervisor);
        }

        public static DeployVirtualMachineOptions keyPair(String keyPair) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.keyPair(keyPair);
        }

        public static DeployVirtualMachineOptions name(String name) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.name(name);
        }

        public static DeployVirtualMachineOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.ipOnDefaultNetwork(ipOnDefaultNetwork);
        }

        public static DeployVirtualMachineOptions ipsToNetworks(Map<String, String> ipsToNetworks) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.ipsToNetworks(ipsToNetworks);
        }

        public static DeployVirtualMachineOptions networkId(String id) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.networkId(id);
        }

        public static DeployVirtualMachineOptions networkIds(Iterable<String> networkIds) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.networkIds(networkIds);
        }

        public static DeployVirtualMachineOptions securityGroupId(String id) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.securityGroupId(id);
        }

        public static DeployVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static DeployVirtualMachineOptions dataDiskSize(long id) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.dataDiskSize(id);
        }

        public static DeployVirtualMachineOptions userData(byte[] unencodedData) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.userData(unencodedData);
        }

        public static DeployVirtualMachineOptions accountInDomain(String account, String domain) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.accountInDomain(account, domain);
        }

        public static DeployVirtualMachineOptions domainId(String domainId) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.domainId(domainId);
        }
    }
}

