/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.logging.Logger;

@Singleton
public class VirtualMachineExpunged
implements Predicate<VirtualMachine> {
    private final CloudStackClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public VirtualMachineExpunged(CloudStackClient client) {
        this.client = client;
    }

    public boolean apply(VirtualMachine virtualMachine) {
        this.logger.trace("looking for state on virtualMachine %s", new Object[]{Preconditions.checkNotNull((Object)virtualMachine, (Object)"virtualMachine")});
        return this.refresh(virtualMachine) == null;
    }

    private VirtualMachine refresh(VirtualMachine virtualMachine) {
        return this.client.getVirtualMachineClient().getVirtualMachine(virtualMachine.getId());
    }
}

