/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.compute.functions.ServiceOfferingToHardware;
import org.jclouds.cloudstack.compute.functions.TemplateToImage;
import org.jclouds.cloudstack.compute.functions.TemplateToOperatingSystem;
import org.jclouds.cloudstack.compute.functions.VirtualMachineToNodeMetadata;
import org.jclouds.cloudstack.compute.functions.ZoneToLocation;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.AdvancedNetworkOptionsConverter;
import org.jclouds.cloudstack.compute.strategy.BasicNetworkOptionsConverter;
import org.jclouds.cloudstack.compute.strategy.CloudStackComputeServiceAdapter;
import org.jclouds.cloudstack.compute.strategy.OptionsConverter;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.GuestOSClient;
import org.jclouds.cloudstack.functions.GetFirewallRulesByVirtualMachine;
import org.jclouds.cloudstack.functions.GetIPForwardingRulesByVirtualMachine;
import org.jclouds.cloudstack.functions.StaticNATVirtualMachineInNetwork;
import org.jclouds.cloudstack.functions.ZoneIdToZone;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.cloudstack.predicates.JobComplete;
import org.jclouds.cloudstack.suppliers.GetCurrentUser;
import org.jclouds.cloudstack.suppliers.NetworksForCurrentUser;
import org.jclouds.cloudstack.suppliers.ZoneIdToZoneSupplier;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

public class CloudStackComputeServiceContextModule
extends ComputeServiceAdapterContextModule<VirtualMachine, ServiceOffering, Template, Zone> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VirtualMachine, ServiceOffering, Template, Zone>>(){}).to(CloudStackComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualMachine, NodeMetadata>>(){}).to(VirtualMachineToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Template, Image>>(){}).to(TemplateToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServiceOffering, Hardware>>(){}).to(ServiceOfferingToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Zone, Location>>(){}).to(ZoneToLocation.class);
        this.bind(TemplateOptions.class).to(CloudStackTemplateOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Template, OperatingSystem>>(){}).to(TemplateToOperatingSystem.class);
        this.install(new FactoryModuleBuilder().build(StaticNATVirtualMachineInNetwork.Factory.class));
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, Set<IPForwardingRule>>>(){}).to(GetIPForwardingRulesByVirtualMachine.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, Set<FirewallRule>>>(){}).to(GetFirewallRulesByVirtualMachine.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, Zone>>(){}).to(ZoneIdToZone.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<String, Zone>>>(){}).to(ZoneIdToZoneSupplier.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<VirtualMachine, ServiceOffering, Template, Zone>(){});
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<String, String>> listOSCategories(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, final CloudStackClient client) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                GuestOSClient guestOSClient = client.getGuestOSClient();
                return guestOSClient.listOSCategories();
            }

            public String toString() {
                return Objects.toStringHelper((Object)client.getGuestOSClient()).add("method", (Object)"listOSCategories").toString();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<String, OSType>> listOSTypes(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, final CloudStackClient client) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)new Supplier<Map<String, OSType>>(){

            public Map<String, OSType> get() {
                GuestOSClient guestOSClient = client.getGuestOSClient();
                return Maps.uniqueIndex(guestOSClient.listOSTypes(new ListOSTypesOptions[0]), (Function)new Function<OSType, String>(){

                    public String apply(OSType arg0) {
                        return arg0.getId();
                    }
                });
            }

            public String toString() {
                return Objects.toStringHelper((Object)client.getGuestOSClient()).add("method", (Object)"listOSTypes").toString();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<String, Network>> listNetworks(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, NetworksForCurrentUser networksForCurrentUser) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)networksForCurrentUser, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<User> getCurrentUser(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, GetCurrentUser getCurrentUser) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)getCurrentUser, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Predicate<String> jobComplete(JobComplete jobComplete) {
        return new RetryablePredicate((Predicate)jobComplete, 1200L, 1L, 5L, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected LoadingCache<String, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine(CacheLoader<String, Set<IPForwardingRule>> getIPForwardingRules) {
        return CacheBuilder.newBuilder().build(getIPForwardingRules);
    }

    @Provides
    @Singleton
    protected LoadingCache<String, Set<FirewallRule>> getFirewallRulesByVirtualMachine(CacheLoader<String, Set<FirewallRule>> getFirewallRules) {
        return CacheBuilder.newBuilder().build(getFirewallRules);
    }

    @Provides
    @Singleton
    public Map<NetworkType, ? extends OptionsConverter> optionsConverters() {
        return ImmutableMap.of((Object)((Object)NetworkType.ADVANCED), (Object)new AdvancedNetworkOptionsConverter(), (Object)((Object)NetworkType.BASIC), (Object)new BasicNetworkOptionsConverter());
    }
}

