/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class ISOPermissions {
    private final String id;
    private final Set<String> accounts;
    private final String domainId;
    private final boolean isPublic;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromISOPermissions(this);
    }

    @ConstructorProperties(value={"id", "account", "domainid", "ispublic"})
    protected ISOPermissions(String id, @Nullable Set<String> accounts, @Nullable String domainId, boolean isPublic) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.accounts = accounts == null ? ImmutableSet.of() : ImmutableSet.copyOf(accounts);
        this.domainId = domainId;
        this.isPublic = isPublic;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getAccounts() {
        return this.accounts;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.accounts, this.domainId, this.isPublic});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ISOPermissions that = (ISOPermissions)ISOPermissions.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.accounts, that.accounts) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.isPublic, (Object)that.isPublic);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("accounts", this.accounts).add("domainId", (Object)this.domainId).add("isPublic", this.isPublic);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected Set<String> accounts = ImmutableSet.of();
        protected String domainId;
        protected boolean isPublic;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T accounts(Set<String> accounts) {
            this.accounts = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(accounts, (Object)"accounts")));
            return this.self();
        }

        public T accounts(String ... in) {
            return this.accounts((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this.self();
        }

        public ISOPermissions build() {
            return new ISOPermissions(this.id, this.accounts, this.domainId, this.isPublic);
        }

        public T fromISOPermissions(ISOPermissions in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).accounts(in.getAccounts())).domainId(in.getDomainId())).isPublic(in.isPublic());
        }
    }
}

