/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.utils.Queries;

public class ReEncodeQueryWithDefaultURLEncoder
implements HttpRequestFilter {
    private final Provider<UriBuilder> builders;

    @Inject
    public ReEncodeQueryWithDefaultURLEncoder(Provider<UriBuilder> builders) {
        this.builders = builders;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        UriBuilder builder = (UriBuilder)this.builders.get();
        builder.uri(request.getEndpoint());
        Multimap map = Queries.parseQueryToMap((String)request.getEndpoint().getRawQuery());
        builder.replaceQuery("");
        for (String key : map.keySet()) {
            builder.queryParam(key, new Object[]{Iterables.getOnlyElement((Iterable)map.get((Object)key))});
        }
        return request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }
}

