/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.ZoneClient;

public class ZoneIdToZone
extends CacheLoader<String, Zone> {
    private final ZoneClient zoneClient;

    @Inject
    public ZoneIdToZone(CloudStackClient client) {
        Preconditions.checkNotNull((Object)client, (Object)"client");
        this.zoneClient = client.getZoneClient();
    }

    public Zone load(String zoneId) throws Exception {
        Preconditions.checkNotNull((Object)zoneId, (Object)"zoneId");
        return this.zoneClient.getZone(zoneId);
    }
}

