/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import org.jclouds.deltacloud.domain.HardwareParameter;
import org.jclouds.deltacloud.domain.HardwareProperty;
import org.jclouds.deltacloud.domain.ParameterizedHardwareProperty;

public class RangeHardwareProperty
extends ParameterizedHardwareProperty {
    private final Number first;
    private final Number last;

    public RangeHardwareProperty(String name, String unit, Number value, HardwareParameter param, Number first, Number last) {
        super(HardwareProperty.Kind.FIXED, name, unit, value, param);
        this.first = (Number)Preconditions.checkNotNull((Object)first, (Object)"first");
        this.last = (Number)Preconditions.checkNotNull((Object)last, (Object)"last");
    }

    public Number getFirst() {
        return this.first;
    }

    public Number getLast() {
        return this.last;
    }

    @Override
    public String toString() {
        return "[kind=" + (Object)((Object)this.getKind()) + ", name=" + this.getName() + ", unit=" + this.getUnit() + ", value=" + this.getValue() + ", param=" + this.getParam() + ", first=" + this.first + ", last=" + this.last + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.last == null ? 0 : this.last.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeHardwareProperty other = (RangeHardwareProperty)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.last == null ? other.last != null : !this.last.equals(other.last));
    }
}

