/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.deltacloud.DeltacloudAsyncClient;
import org.jclouds.deltacloud.DeltacloudClient;
import org.jclouds.deltacloud.collections.HardwareProfiles;
import org.jclouds.deltacloud.collections.Images;
import org.jclouds.deltacloud.collections.InstanceStates;
import org.jclouds.deltacloud.collections.Instances;
import org.jclouds.deltacloud.collections.Realms;
import org.jclouds.deltacloud.domain.DeltacloudCollection;
import org.jclouds.deltacloud.handlers.DeltacloudErrorHandler;
import org.jclouds.deltacloud.handlers.DeltacloudRedirectionRetryHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

@ConfiguresRestClient
public class DeltacloudRestClientModule
extends RestClientModule<DeltacloudClient, DeltacloudAsyncClient> {
    protected AtomicReference<AuthorizationException> authException = new AtomicReference();

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(DeltacloudErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(DeltacloudErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(DeltacloudErrorHandler.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(Redirection.class).to(DeltacloudRedirectionRetryHandler.class);
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends DeltacloudCollection>> provideCollections(@Named(value="jclouds.session-interval") long seconds, final DeltacloudClient client) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Set<? extends DeltacloudCollection>>(){

            public Set<? extends DeltacloudCollection> get() {
                return client.getCollections();
            }
        });
    }

    @Provides
    @Images
    protected Supplier<URI> provideImageCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return Suppliers.compose((Function)new FindCollectionWithRelAndReturnHref("images"), collectionSupplier);
    }

    @Provides
    @HardwareProfiles
    protected Supplier<URI> provideHardwareProfileCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return Suppliers.compose((Function)new FindCollectionWithRelAndReturnHref("hardware_profiles"), collectionSupplier);
    }

    @Provides
    @Instances
    protected Supplier<URI> provideInstanceCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return Suppliers.compose((Function)new FindCollectionWithRelAndReturnHref("instances"), collectionSupplier);
    }

    @Provides
    @Realms
    protected Supplier<URI> provideRealmCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return Suppliers.compose((Function)new FindCollectionWithRelAndReturnHref("realms"), collectionSupplier);
    }

    @Provides
    @InstanceStates
    protected Supplier<URI> provideInstanceStateCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return Suppliers.compose((Function)new FindCollectionWithRelAndReturnHref("instance_states"), collectionSupplier);
    }

    public static class FindCollectionWithRelAndReturnHref
    implements Function<Set<? extends DeltacloudCollection>, URI> {
        private final String rel;

        public FindCollectionWithRelAndReturnHref(String rel) {
            this.rel = rel;
        }

        public URI apply(Set<? extends DeltacloudCollection> arg0) {
            try {
                return ((DeltacloudCollection)Iterables.find(arg0, (Predicate)new Predicate<DeltacloudCollection>(){

                    public boolean apply(DeltacloudCollection arg0) {
                        return arg0.getRel().equals(FindCollectionWithRelAndReturnHref.this.rel);
                    }
                })).getHref();
            }
            catch (NoSuchElementException e) {
                throw new NoSuchElementException("could not find rel " + this.rel + " in collections " + arg0);
            }
        }
    }
}

