/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jclouds.deltacloud.domain.EnumHardwareProperty;
import org.jclouds.deltacloud.domain.FixedHardwareProperty;
import org.jclouds.deltacloud.domain.HardwareParameter;
import org.jclouds.deltacloud.domain.HardwareProperty;
import org.jclouds.deltacloud.domain.RangeHardwareProperty;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HardwarePropertyHandler
extends ParseSax.HandlerWithResult<HardwareProperty> {
    private HardwareProperty.Kind kind;
    private String name;
    private String unit;
    private Object value;
    private HardwareParameter param;
    private Set<Object> availableValues = Sets.newLinkedHashSet();
    private Number first;
    private Number last;
    private static final Pattern LONG = Pattern.compile("^[0-9]+$");
    private static final Pattern DOUBLE = Pattern.compile("^[0-9]+\\.[0-9]+$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwareProperty getResult() {
        try {
            switch (this.kind) {
                case FIXED: {
                    FixedHardwareProperty fixedHardwareProperty = new FixedHardwareProperty(this.name, this.unit, this.value);
                    return fixedHardwareProperty;
                }
                case ENUM: {
                    EnumHardwareProperty enumHardwareProperty = new EnumHardwareProperty(this.name, this.unit, this.value, this.param, this.availableValues);
                    return enumHardwareProperty;
                }
                case RANGE: {
                    RangeHardwareProperty rangeHardwareProperty = new RangeHardwareProperty(this.name, this.unit, (Number)this.value, this.param, this.first, this.last);
                    return rangeHardwareProperty;
                }
            }
            HardwareProperty hardwareProperty = null;
            return hardwareProperty;
        }
        finally {
            this.kind = null;
            this.name = null;
            this.unit = null;
            this.value = null;
            this.param = null;
            this.availableValues = Sets.newLinkedHashSet();
            this.first = null;
            this.last = null;
        }
    }

    @Nullable
    public static Number parseNumberOrNull(String in) {
        if (DOUBLE.matcher(in).matches()) {
            return new Double(in);
        }
        if (LONG.matcher(in).matches()) {
            return new Long(in);
        }
        return null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.equals("property")) {
            this.kind = HardwareProperty.Kind.fromValue((String)attributes.get("kind"));
            this.name = (String)attributes.get("name");
            this.unit = (String)attributes.get("unit");
            if (attributes.containsKey("value")) {
                this.value = HardwarePropertyHandler.stringOrNumber((String)attributes.get("value"));
            }
        } else if (qName.equals("param")) {
            this.param = new HardwareParameter(URI.create((String)attributes.get("href")), (String)attributes.get("method"), (String)attributes.get("name"), (String)attributes.get("operation"));
        } else if (qName.equals("range")) {
            this.first = HardwarePropertyHandler.parseNumberOrNull((String)attributes.get("first"));
            this.last = HardwarePropertyHandler.parseNumberOrNull((String)attributes.get("last"));
        } else if (qName.equals("entry")) {
            this.availableValues.add(HardwarePropertyHandler.stringOrNumber((String)attributes.get("value")));
        }
    }

    public static Object stringOrNumber(String in) {
        Number number = HardwarePropertyHandler.parseNumberOrNull(in);
        return number != null ? number : in;
    }
}

