/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.deltacloud.domain.DeltacloudCollection;
import org.jclouds.deltacloud.xml.DeltacloudCollectionHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DeltacloudCollectionsHandler
extends ParseSax.HandlerWithResult<Set<? extends DeltacloudCollection>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<DeltacloudCollection> links = Sets.newLinkedHashSet();
    private final DeltacloudCollectionHandler linkHandler;

    @Inject
    public DeltacloudCollectionsHandler(DeltacloudCollectionHandler linkHandler) {
        this.linkHandler = linkHandler;
    }

    public Set<? extends DeltacloudCollection> getResult() {
        return this.links;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.linkHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.linkHandler.endElement(uri, localName, qName);
        if (qName.equals("link") && this.currentText.toString().trim().equals("")) {
            this.links.add(this.linkHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

